/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import com.dracolich777.afterlifeentombed.init.ModEffects;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SethsTrickery
extends SwordItem {
    public SethsTrickery(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, 3, -2.4f, properties);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.REVENGE_OF_SETH.get(), 100, 0));
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        Optional<LivingEntity> targetEntity;
        if (!level.f_46443_ && (targetEntity = this.getEntityPlayerIsLookingAt(player, level, 20.0)).isPresent()) {
            LivingEntity target = targetEntity.get();
            float entityYaw = target.f_20885_;
            double yawRadians = Math.toRadians(entityYaw);
            double dirX = -Math.sin(yawRadians);
            double dirZ = Math.cos(yawRadians);
            Vec3 entityFacingDirection = new Vec3(dirX, 0.0, dirZ).m_82541_();
            double distanceBehind = 1.5;
            Vec3 teleportPos = target.m_20182_().m_82546_(entityFacingDirection.m_82490_(distanceBehind));
            teleportPos = new Vec3(teleportPos.f_82479_, target.m_20186_(), teleportPos.f_82481_);
            player.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
            Vec3 targetCenter = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            Vec3 playerEye = player.m_146892_();
            Vec3 lookDirection = targetCenter.m_82546_(playerEye).m_82541_();
            float yaw = (float)Math.toDegrees(Math.atan2(-lookDirection.f_82479_, lookDirection.f_82481_));
            float pitch = (float)Math.toDegrees(Math.asin(-lookDirection.f_82480_));
            player.m_146922_(yaw);
            player.m_146926_(pitch);
            player.m_36335_().m_41524_((Item)this, 60);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    private Optional<LivingEntity> getEntityPlayerIsLookingAt(Player player, Level level, double range) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(range));
        AABB searchBox = new AABB(eyePos, endPos).m_82400_(1.0);
        LivingEntity closestEntity = null;
        double closestDistance = range + 1.0;
        List entities = level.m_45976_(LivingEntity.class, searchBox);
        for (LivingEntity entity : entities) {
            double distance;
            AABB entityBox;
            Optional hitVec;
            if (entity == player || !(hitVec = (entityBox = entity.m_20191_().m_82400_(0.3)).m_82371_(eyePos, endPos)).isPresent() || !((distance = eyePos.m_82554_((Vec3)hitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        return Optional.ofNullable(closestEntity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.seths_trickery.tooltip1").m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.seths_trickery.tooltip2").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.seths_trickery.tooltip3").m_130940_(ChatFormatting.DARK_PURPLE));
    }
}

