/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.mixins;

import com.dracolich777.afterlifeentombed.items.GodseekerSword;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class GodseekerSwordClickMixin {
    @Shadow
    private ItemStack draggingItem;

    @Shadow
    protected abstract Slot getSlotUnderMouse();

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        ItemStack hoveredItem;
        Slot hoveredSlot = this.getSlotUnderMouse();
        if (hoveredSlot != null && hoveredSlot.m_6657_() && (hoveredItem = hoveredSlot.m_7993_()).m_41720_() instanceof GodseekerSword) {
            int slotX = (int)mouseX - 8;
            int slotY = (int)mouseY + 25;
            if (mouseX >= (double)slotX && mouseX <= (double)(slotX + 18) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 18)) {
                if (button == 0) {
                    this.handleGodseekerSlotClick(hoveredItem);
                    cir.setReturnValue((Object)true);
                } else if (button == 1) {
                    this.handleGodseekerSlotRightClick(hoveredItem);
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    private void handleGodseekerSlotClick(ItemStack swordStack) {
        ItemStack currentGodstone = GodseekerSword.getGodstoneeItem(swordStack);
        if (!this.draggingItem.m_41619_()) {
            if (GodseekerSword.isValidGodstone(this.draggingItem)) {
                if (currentGodstone.m_41619_()) {
                    ItemStack toInsert = this.draggingItem.m_41777_();
                    toInsert.m_41764_(1);
                    GodseekerSword.setGodstoneeItem(swordStack, toInsert);
                    this.draggingItem.m_41774_(1);
                    if (this.draggingItem.m_41619_()) {
                        this.draggingItem = ItemStack.f_41583_;
                    }
                } else {
                    ItemStack temp = currentGodstone.m_41777_();
                    ItemStack toInsert = this.draggingItem.m_41777_();
                    toInsert.m_41764_(1);
                    GodseekerSword.setGodstoneeItem(swordStack, toInsert);
                    this.draggingItem.m_41774_(1);
                    if (this.draggingItem.m_41619_()) {
                        this.draggingItem = temp;
                    } else {
                        this.addToPlayerInventory(temp);
                    }
                }
            }
        } else if (!currentGodstone.m_41619_()) {
            this.draggingItem = currentGodstone.m_41777_();
            GodseekerSword.setGodstoneeItem(swordStack, ItemStack.f_41583_);
        }
    }

    private void handleGodseekerSlotRightClick(ItemStack swordStack) {
        ItemStack currentGodstone = GodseekerSword.getGodstoneeItem(swordStack);
        if (!currentGodstone.m_41619_()) {
            GodseekerSword.setGodstoneeItem(swordStack, ItemStack.f_41583_);
            this.addToPlayerInventory(currentGodstone);
        }
    }

    private void addToPlayerInventory(ItemStack item) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !player.m_150109_().m_36054_(item)) {
            player.m_36176_(item, false);
        }
    }
}

