/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class GodHoldInventory
extends SavedData {
    private static final String DATA_NAME = "afterlifeentombed_godhold_inventories";
    private static final int INVENTORY_SIZE = 54;
    private Map<UUID, NonNullList<ItemStack>> inventories = new HashMap<UUID, NonNullList<ItemStack>>();

    public static GodHoldInventory get(ServerLevel level) {
        return (GodHoldInventory)level.m_8895_().m_164861_(GodHoldInventory::load, GodHoldInventory::new, DATA_NAME);
    }

    public static GodHoldInventory load(CompoundTag tag) {
        GodHoldInventory data = new GodHoldInventory();
        CompoundTag inventoriesTag = tag.m_128469_("inventories");
        for (String key : inventoriesTag.m_128431_()) {
            UUID id = UUID.fromString(key);
            NonNullList items = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
            ListTag itemsTag = inventoriesTag.m_128437_(key, 10);
            for (int i = 0; i < itemsTag.size(); ++i) {
                CompoundTag itemTag = itemsTag.m_128728_(i);
                int slot = itemTag.m_128451_("Slot");
                if (slot < 0 || slot >= items.size()) continue;
                items.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
            }
            data.inventories.put(id, (NonNullList<ItemStack>)items);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag inventoriesTag = new CompoundTag();
        for (Map.Entry<UUID, NonNullList<ItemStack>> entry : this.inventories.entrySet()) {
            ListTag itemsTag = new ListTag();
            NonNullList<ItemStack> items = entry.getValue();
            for (int i = 0; i < items.size(); ++i) {
                ItemStack stack = (ItemStack)items.get(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                stack.m_41739_(itemTag);
                itemsTag.add((Object)itemTag);
            }
            inventoriesTag.m_128365_(entry.getKey().toString(), (Tag)itemsTag);
        }
        tag.m_128365_("inventories", (Tag)inventoriesTag);
        return tag;
    }

    public NonNullList<ItemStack> getInventory(UUID inventoryId) {
        return this.inventories.computeIfAbsent(inventoryId, k -> NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_));
    }

    public void setInventory(UUID inventoryId, NonNullList<ItemStack> items) {
        this.inventories.put(inventoryId, items);
        this.m_77762_();
    }

    public void markDirty() {
        this.m_77762_();
    }

    public UUID createNewInventory() {
        UUID newId = UUID.randomUUID();
        this.inventories.put(newId, (NonNullList<ItemStack>)NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_));
        this.m_77762_();
        return newId;
    }

    public static int getInventorySize() {
        return 54;
    }
}

