/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.util;

import com.dracolich777.afterlifeentombed.init.ModItems;
import com.dracolich777.afterlifeentombed.items.GodType;
import com.dracolich777.afterlifeentombed.util.ModPotions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class GodstoneBrewingRecipe
implements IBrewingRecipe {
    private final Item godstone;
    private final Potion outputPotion;

    public GodstoneBrewingRecipe(Item godstone, Potion outputPotion) {
        this.godstone = godstone;
        this.outputPotion = outputPotion;
    }

    public boolean isInput(ItemStack input) {
        return input.m_41720_() == Items.f_42589_ && PotionUtils.m_43579_((ItemStack)input) == Potions.f_43602_;
    }

    public boolean isIngredient(ItemStack ingredient) {
        return ingredient.m_41720_() == this.godstone;
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)this.outputPotion);
        }
        return ItemStack.f_41583_;
    }

    public static void registerAll() {
        for (GodType god : GodType.values()) {
            Item godstoneItem = GodstoneBrewingRecipe.getGodstoneFor(god);
            Potion resultPotion = GodstoneBrewingRecipe.getPotionForGod(god);
            if (godstoneItem == null || resultPotion == null) continue;
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new GodstoneBrewingRecipe(godstoneItem, resultPotion));
        }
    }

    private static Item getGodstoneFor(GodType god) {
        switch (god) {
            case RA: {
                return (Item)ModItems.GODSTONE_OF_RA.get();
            }
            case ANUBIS: {
                return (Item)ModItems.GODSTONE_OF_ANUBIS.get();
            }
            case ISIS: {
                return (Item)ModItems.GODSTONE_OF_ISIS.get();
            }
            case SETH: {
                return (Item)ModItems.GODSTONE_OF_SETH.get();
            }
            case GEB: {
                return (Item)ModItems.GODSTONE_OF_GEB.get();
            }
            case HORUS: {
                return (Item)ModItems.GODSTONE_OF_HORUS.get();
            }
            case THOTH: {
                return (Item)ModItems.GODSTONE_OF_THOTH.get();
            }
            case SHU: {
                return (Item)ModItems.GODSTONE_OF_SHU.get();
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    private static Potion getPotionForGod(GodType god) {
        switch (god) {
            case RA: {
                return (Potion)ModPotions.HOLY_FIRE.get();
            }
            case ANUBIS: {
                return (Potion)ModPotions.REVENGE_OF_ANUBIS.get();
            }
            case ISIS: {
                return (Potion)ModPotions.REVENGE_OF_ISIS.get();
            }
            case SETH: {
                return (Potion)ModPotions.REVENGE_OF_SETH.get();
            }
            case GEB: {
                return (Potion)ModPotions.REVENGE_OF_GEB.get();
            }
            case HORUS: {
                return (Potion)ModPotions.REVENGE_OF_HORUS.get();
            }
            case THOTH: {
                return (Potion)ModPotions.REVENGE_OF_THOTH.get();
            }
            case SHU: {
                return (Potion)ModPotions.REVENGE_OF_SHU.get();
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }
}

