/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlibs.api;

import com.dracolich777.afterlibs.network.NetworkHandler;
import com.dracolich777.afterlibs.particle.ParticleManager;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class AfterLibsAPI {
    public static boolean spawnAfterlifeParticle(Level level, String particleName, double x, double y, double z, float scale) {
        if (level == null) {
            return false;
        }
        if (level.m_5776_()) {
            return ParticleManager.spawnParticle(level, particleName, x, y, z, scale);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            NetworkHandler.sendParticleToAll(serverLevel, particleName, x, y, z, scale);
            return true;
        }
        return false;
    }

    public static boolean spawnAfterlifeParticle(Level level, String particleName, double x, double y, double z, float scaleX, float scaleY, float scaleZ) {
        if (level == null) {
            return false;
        }
        if (level.m_5776_()) {
            return ParticleManager.spawnParticle(level, particleName, x, y, z, scaleX, scaleY, scaleZ, 0.0f, 0.0f, 0.0f);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            NetworkHandler.sendParticleToAll(serverLevel, particleName, x, y, z, scaleX, scaleY, scaleZ);
            return true;
        }
        return false;
    }

    public static boolean spawnAfterlifeParticleForPlayer(ServerPlayer player, String particleName, double x, double y, double z, float scale) {
        if (player == null) {
            return false;
        }
        NetworkHandler.sendParticleToPlayer(player, particleName, x, y, z, scale);
        return true;
    }

    public static boolean spawnAfterlifeParticleNearby(ServerLevel level, String particleName, double x, double y, double z, float scale, double range) {
        if (level == null) {
            return false;
        }
        NetworkHandler.sendParticleToNearby(level, particleName, x, y, z, scale, range);
        return true;
    }

    public static boolean isParticleAvailable(String particleName) {
        return ParticleManager.hasParticle(particleName);
    }

    public static Set<String> getAvailableParticles() {
        return ParticleManager.getAvailableParticles();
    }

    public static int getParticleCount() {
        return AfterLibsAPI.getAvailableParticles().size();
    }
}

