/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlibs.api.examples;

import com.dracolich777.afterlibs.api.AfterLibsAPI;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class AfterLibsAPIExamples {
    public static void basicParticleExample(Level level, double x, double y, double z) {
        boolean success = AfterLibsAPI.spawnAfterlifeParticle(level, "horus_shield", x, y, z, 2.0f);
        if (success) {
            System.out.println("Successfully spawned horus_shield particle!");
        } else {
            System.out.println("Failed to spawn particle - check if particle name is valid");
        }
    }

    public static void customScaleExample(Level level, double x, double y, double z) {
        AfterLibsAPI.spawnAfterlifeParticle(level, "seth_crown_appear", x, y, z, 0.5f, 3.0f, 0.5f);
    }

    public static void playerSpecificExample(ServerPlayer player, double x, double y, double z) {
        AfterLibsAPI.spawnAfterlifeParticleForPlayer(player, "haze_flash", x, y, z, 1.5f);
    }

    public static void areaBasedExample(ServerLevel level, double x, double y, double z) {
        AfterLibsAPI.spawnAfterlifeParticleNearby(level, "shield_wall", x, y, z, 1.0f, 50.0);
    }

    public static void particleValidationExample() {
        if (AfterLibsAPI.isParticleAvailable("horus_shield")) {
            System.out.println("Horus shield particle is available!");
        }
        System.out.println("Available particles: " + String.valueOf(AfterLibsAPI.getAvailableParticles()));
        System.out.println("Total particles: " + AfterLibsAPI.getParticleCount());
    }

    public static void advancedEffectExample(Level level, double centerX, double centerY, double centerZ) {
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 8.0;
            double x = centerX + Math.cos(angle) * 2.0;
            double z = centerZ + Math.sin(angle) * 2.0;
            AfterLibsAPI.spawnAfterlifeParticle(level, "haze", x, centerY + (double)i * 0.1, z, 0.8f);
        }
        AfterLibsAPI.spawnAfterlifeParticle(level, "horus_shield", centerX, centerY, centerZ, 1.5f);
    }

    public static void eventDrivenExample(Level level, double x, double y, double z, String eventType) {
        switch (eventType) {
            case "player_death": {
                AfterLibsAPI.spawnAfterlifeParticle(level, "seth_crown_disolve", x, y, z, 2.0f);
                break;
            }
            case "player_respawn": {
                AfterLibsAPI.spawnAfterlifeParticle(level, "seth_crown_appear", x, y, z, 1.5f);
                break;
            }
            case "shield_activate": {
                AfterLibsAPI.spawnAfterlifeParticle(level, "shield_wall", x, y, z, 1.0f);
                break;
            }
            case "magic_cast": {
                AfterLibsAPI.spawnAfterlifeParticle(level, "haze_flash", x, y, z, 1.0f);
                AfterLibsAPI.spawnAfterlifeParticle(level, "haze2", x, y + 1.0, z, 0.7f);
                break;
            }
            default: {
                AfterLibsAPI.spawnAfterlifeParticle(level, "haze", x, y, z, 1.0f);
            }
        }
    }
}

