/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlibs.commands;

import com.dracolich777.afterlibs.api.AfterLibsAPI;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AParticleCommand {
    private static final SuggestionProvider<CommandSourceStack> PARTICLE_SUGGESTIONS = (context, builder) -> {
        AfterLibsAPI.getAvailableParticles().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"aparticle").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"particle", (ArgumentType)StringArgumentType.string()).suggests(PARTICLE_SUGGESTIONS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> AParticleCommand.spawnParticle((CommandContext<CommandSourceStack>)context, Vec3Argument.m_120844_((CommandContext)context, (String)"position"), 1.0f))).then(Commands.m_82129_((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f)).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"scale");
            return AParticleCommand.spawnParticle((CommandContext<CommandSourceStack>)context, Vec3Argument.m_120844_((CommandContext)context, (String)"position"), scale);
        })))));
    }

    private static int spawnParticle(CommandContext<CommandSourceStack> context, Vec3 position, float scale) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String particleName = StringArgumentType.getString(context, (String)"particle");
        if (!AfterLibsAPI.isParticleAvailable(particleName)) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown particle: " + particleName + ". Available particles: " + String.join((CharSequence)", ", AfterLibsAPI.getAvailableParticles()))));
            return 0;
        }
        try {
            boolean success = AfterLibsAPI.spawnAfterlifeParticle((Level)source.m_81372_(), particleName, position.f_82479_, position.f_82480_, position.f_82481_, scale);
            if (success) {
                source.m_288197_(() -> Component.m_237113_((String)String.format("Spawned particle '%s' at (%.2f, %.2f, %.2f) with scale %.2f", particleName, position.f_82479_, position.f_82480_, position.f_82481_, Float.valueOf(scale))), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Failed to spawn particle: " + particleName)));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to spawn particle: " + e.getMessage())));
            return 0;
        }
    }
}

