/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlibs.network;

import com.dracolich777.afterlibs.network.ParticlePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("afterlibs_api", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void register() {
        INSTANCE.messageBuilder(ParticlePacket.class, packetId++, NetworkDirection.PLAY_TO_CLIENT).decoder(ParticlePacket::decode).encoder(ParticlePacket::encode).consumerMainThread(ParticlePacket::handle).add();
    }

    public static void sendParticleToAll(ServerLevel level, String particleName, double x, double y, double z, float scale) {
        ParticlePacket packet = new ParticlePacket(x, y, z, particleName, scale);
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> level.m_46472_()), (Object)packet);
    }

    public static void sendParticleToAll(ServerLevel level, String particleName, double x, double y, double z, float scaleX, float scaleY, float scaleZ) {
        ParticlePacket packet = new ParticlePacket(x, y, z, particleName, scaleX, scaleY, scaleZ);
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> level.m_46472_()), (Object)packet);
    }

    public static void sendParticleToPlayer(ServerPlayer player, String particleName, double x, double y, double z, float scale) {
        ParticlePacket packet = new ParticlePacket(x, y, z, particleName, scale);
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendParticleToNearby(ServerLevel level, String particleName, double x, double y, double z, float scale, double range) {
        ParticlePacket packet = new ParticlePacket(x, y, z, particleName, scale);
        INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, range, level.m_46472_())), (Object)packet);
    }
}

