/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlibs.particle;

import com.dracolich777.afterlibs.util.VerboseLogger;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ParticleManager {
    private static final Map<String, ParticleEmitterInfo> PARTICLES = new HashMap<String, ParticleEmitterInfo>();
    private static final String EFFEKS_PATH = "/assets/afterlibs/effeks/";
    private static final String EFFEKS_EXTENSION = ".efkefc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void discoverAndRegisterParticles() {
        boolean autoDiscoverySucceeded;
        block17: {
            autoDiscoverySucceeded = false;
            try {
                URL effeksUrl = ParticleManager.class.getResource(EFFEKS_PATH);
                if (effeksUrl == null) {
                    VerboseLogger.warn(ParticleManager.class, "Could not find effeks resource path: {}", EFFEKS_PATH);
                    break block17;
                }
                URI effeksUri = effeksUrl.toURI();
                FileSystem fileSystem = null;
                boolean needsClosing = false;
                try {
                    Path effeksPath;
                    if (effeksUri.getScheme().equals("jar")) {
                        fileSystem = FileSystems.newFileSystem(effeksUri, Collections.emptyMap());
                        effeksPath = fileSystem.getPath(EFFEKS_PATH, new String[0]);
                        needsClosing = true;
                        VerboseLogger.info(ParticleManager.class, "Discovering particles from JAR: {}", effeksUri);
                    } else {
                        effeksPath = Paths.get(effeksUri);
                        VerboseLogger.info(ParticleManager.class, "Discovering particles from filesystem: {}", effeksPath);
                    }
                    try (Stream<Path> files = Files.walk(effeksPath, new FileVisitOption[0]);){
                        long particleCount = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(EFFEKS_EXTENSION)).peek(ParticleManager::registerParticleFromPath).count();
                        if (particleCount > 0L) {
                            autoDiscoverySucceeded = true;
                            VerboseLogger.info(ParticleManager.class, "Auto-discovery completed. Found {} particles via filesystem scanning", particleCount);
                        }
                    }
                }
                finally {
                    if (needsClosing && fileSystem != null) {
                        fileSystem.close();
                    }
                }
            }
            catch (Exception e) {
                VerboseLogger.error(ParticleManager.class, "Failed to auto-discover particles: {} - {}", e.getClass().getSimpleName(), e.getMessage());
                VerboseLogger.error(ParticleManager.class, "Exception details: ", e);
            }
        }
        if (!autoDiscoverySucceeded) {
            VerboseLogger.info(ParticleManager.class, "Auto-discovery failed, falling back to manual registration of known particles", new Object[0]);
            ParticleManager.registerFallbackParticles();
        }
    }

    private static void registerParticleFromPath(Path filePath) {
        try {
            String fileName = filePath.getFileName().toString();
            if (fileName.endsWith(EFFEKS_EXTENSION)) {
                String particleName = fileName.substring(0, fileName.length() - EFFEKS_EXTENSION.length());
                ResourceLocation location = new ResourceLocation("afterlibs", particleName);
                ParticleEmitterInfo particle = new ParticleEmitterInfo(location);
                PARTICLES.put(particleName, particle);
                VerboseLogger.info(ParticleManager.class, "Auto-registered particle '{}' from file: {}", particleName, fileName);
            }
        }
        catch (Exception e) {
            VerboseLogger.error(ParticleManager.class, "Failed to register particle from path {}: {} - {}", filePath, e.getClass().getSimpleName(), e.getMessage());
        }
    }

    private static void registerFallbackParticles() {
        String[] knownParticles;
        for (String particleName : knownParticles = new String[]{"horus_shield", "seth_crown_disolve", "seth_crown_appear", "haze", "haze2", "haze3", "haze_flash", "shield_wall", "shu_jump2"}) {
            try {
                String resourcePath = EFFEKS_PATH + particleName + EFFEKS_EXTENSION;
                InputStream testStream = ParticleManager.class.getResourceAsStream(resourcePath);
                if (testStream != null) {
                    testStream.close();
                    ResourceLocation location = new ResourceLocation("afterlibs", particleName);
                    ParticleEmitterInfo particle = new ParticleEmitterInfo(location);
                    PARTICLES.put(particleName, particle);
                    VerboseLogger.info(ParticleManager.class, "Fallback registered particle: {}", particleName);
                    continue;
                }
                VerboseLogger.warn(ParticleManager.class, "Fallback particle not found: {}", particleName);
            }
            catch (Exception e) {
                VerboseLogger.error(ParticleManager.class, "Failed to fallback register particle '{}': {} - {}", particleName, e.getClass().getSimpleName(), e.getMessage());
            }
        }
    }

    public static boolean spawnParticle(Level level, String particleName, double x, double y, double z) {
        return ParticleManager.spawnParticle(level, particleName, x, y, z, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public static boolean spawnParticle(Level level, String particleName, double x, double y, double z, float scale) {
        return ParticleManager.spawnParticle(level, particleName, x, y, z, scale, scale, scale, 0.0f, 0.0f, 0.0f);
    }

    public static boolean spawnParticle(Level level, String particleName, double x, double y, double z, float scaleX, float scaleY, float scaleZ, float yaw, float pitch, float roll) {
        if (level == null) {
            VerboseLogger.warn(ParticleManager.class, "Cannot spawn particle '{}': level is null", particleName);
            return false;
        }
        if (!level.m_5776_()) {
            VerboseLogger.warn(ParticleManager.class, "Cannot spawn particle '{}': must be called on client side", particleName);
            return false;
        }
        ParticleEmitterInfo particle = PARTICLES.get(particleName);
        if (particle == null) {
            VerboseLogger.warn(ParticleManager.class, "Unknown particle name: '{}'. Available particles: {}", particleName, ParticleManager.getAvailableParticles());
            return false;
        }
        try {
            float yawRad = (float)Math.toRadians(yaw);
            float pitchRad = (float)Math.toRadians(pitch);
            float rollRad = (float)Math.toRadians(roll);
            AAALevel.addParticle((Level)level, (ParticleEmitterInfo)particle.position(x, y, z).rotation(yawRad, pitchRad, rollRad).scale(scaleX, scaleY, scaleZ));
            VerboseLogger.info(ParticleManager.class, "Successfully spawned particle '{}' at ({}, {}, {}) with scale ({}, {}, {})", particleName, x, y, z, Float.valueOf(scaleX), Float.valueOf(scaleY), Float.valueOf(scaleZ));
            return true;
        }
        catch (Exception e) {
            VerboseLogger.error(ParticleManager.class, "Failed to spawn particle '{}': {}", particleName, e.getMessage());
            return false;
        }
    }

    public static boolean hasParticle(String particleName) {
        return PARTICLES.containsKey(particleName);
    }

    public static Set<String> getAvailableParticles() {
        return PARTICLES.keySet();
    }

    public static ParticleEmitterInfo getParticle(String particleName) {
        return PARTICLES.get(particleName);
    }

    public static int getParticleCount() {
        return PARTICLES.size();
    }

    static {
        ParticleManager.discoverAndRegisterParticles();
        VerboseLogger.info(ParticleManager.class, "Auto-registered {} particles from effeks folder", PARTICLES.size());
        if (!PARTICLES.isEmpty()) {
            VerboseLogger.info(ParticleManager.class, "Available particles: {}", PARTICLES.keySet());
        }
    }
}

