/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlibs.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerboseLogger {
    private static final Map<String, Logger> LOGGERS = new ConcurrentHashMap<String, Logger>();
    private static boolean globalVerboseMode = false;
    private static final Map<String, Level> classLogLevels = new ConcurrentHashMap<String, Level>();

    public static void setVerboseMode(boolean enabled) {
        globalVerboseMode = enabled;
        if (enabled) {
            VerboseLogger.getLogger(VerboseLogger.class).info("=== VERBOSE LOGGING ENABLED GLOBALLY ===");
        } else {
            VerboseLogger.getLogger(VerboseLogger.class).info("=== VERBOSE LOGGING DISABLED GLOBALLY ===");
        }
    }

    public static boolean isVerboseMode() {
        return globalVerboseMode;
    }

    public static void setLogLevel(Class<?> clazz, Level level) {
        classLogLevels.put(clazz.getName(), level);
        VerboseLogger.getLogger(clazz).info("Log level set to {} for class {}", (Object)level, (Object)clazz.getSimpleName());
    }

    public static Logger getLogger(Class<?> clazz) {
        return LOGGERS.computeIfAbsent(clazz.getName(), k -> LogManager.getLogger((Class)clazz));
    }

    public static Logger getLogger() {
        String callerClassName = VerboseLogger.getCallerClassName();
        return LOGGERS.computeIfAbsent(callerClassName, k -> LogManager.getLogger((String)callerClassName));
    }

    public static void verbose(Class<?> clazz, String message, Object ... args) {
        if (globalVerboseMode || VerboseLogger.shouldLog(clazz, Level.DEBUG)) {
            VerboseLogger.getLogger(clazz).debug("[VERBOSE] " + message, args);
        }
    }

    public static void verbose(String message, Object ... args) {
        if (globalVerboseMode) {
            VerboseLogger.getLogger().debug("[VERBOSE] " + message, args);
        }
    }

    public static void info(Class<?> clazz, String message, Object ... args) {
        if (VerboseLogger.shouldLog(clazz, Level.INFO)) {
            VerboseLogger.getLogger(clazz).info(message, args);
        }
    }

    public static void info(String message, Object ... args) {
        VerboseLogger.getLogger().info(message, args);
    }

    public static void warn(Class<?> clazz, String message, Object ... args) {
        VerboseLogger.getLogger(clazz).warn(message, args);
    }

    public static void warn(String message, Object ... args) {
        VerboseLogger.getLogger().warn(message, args);
    }

    public static void error(Class<?> clazz, String message, Object ... args) {
        VerboseLogger.getLogger(clazz).error(message, args);
    }

    public static void error(String message, Object ... args) {
        VerboseLogger.getLogger().error(message, args);
    }

    public static void error(Class<?> clazz, String message, Throwable throwable) {
        VerboseLogger.getLogger(clazz).error(message, throwable);
    }

    public static void error(String message, Throwable throwable) {
        VerboseLogger.getLogger().error(message, throwable);
    }

    public static void debug(Class<?> clazz, String message, Object ... args) {
        if (VerboseLogger.shouldLog(clazz, Level.DEBUG)) {
            VerboseLogger.getLogger(clazz).debug(message, args);
        }
    }

    public static void debug(String message, Object ... args) {
        VerboseLogger.getLogger().debug(message, args);
    }

    public static void logExecutionTime(Class<?> clazz, String taskName, long startTime) {
        long endTime = System.nanoTime();
        double durationMs = (double)(endTime - startTime) / 1000000.0;
        if (globalVerboseMode || VerboseLogger.shouldLog(clazz, Level.DEBUG)) {
            VerboseLogger.getLogger(clazz).debug("[PERFORMANCE] {} completed in {:.3f}ms", (Object)taskName, (Object)durationMs);
        }
    }

    public static void logSeparator(Class<?> clazz, String title) {
        if (globalVerboseMode || VerboseLogger.shouldLog(clazz, Level.INFO)) {
            if (title != null && !title.isEmpty()) {
                VerboseLogger.getLogger(clazz).info("=".repeat(20) + " {} " + "=".repeat(20), (Object)title);
            } else {
                VerboseLogger.getLogger(clazz).info("=".repeat(50));
            }
        }
    }

    public static void logSeparator(String title) {
        if (globalVerboseMode) {
            if (title != null && !title.isEmpty()) {
                VerboseLogger.getLogger().info("=".repeat(20) + " {} " + "=".repeat(20), (Object)title);
            } else {
                VerboseLogger.getLogger().info("=".repeat(50));
            }
        }
    }

    private static boolean shouldLog(Class<?> clazz, Level level) {
        Level classLevel = classLogLevels.get(clazz.getName());
        if (classLevel != null) {
            return level.isMoreSpecificThan(classLevel);
        }
        return true;
    }

    private static String getCallerClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 3) {
            return stackTrace[3].getClassName();
        }
        return "Unknown";
    }

    public static void printStackTrace(Class<?> clazz) {
        if (globalVerboseMode) {
            Logger logger = VerboseLogger.getLogger(clazz);
            logger.debug("=== STACK TRACE ===");
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 2; i < stackTrace.length; ++i) {
                logger.debug("  at {}", (Object)stackTrace[i]);
            }
        }
    }
}

