/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.blockentities;

import com.dracolich777.afterlifeentombed.init.ModBlockEntities;
import com.dracolich777.afterlifeentombed.menu.GodHoldMenu;
import com.dracolich777.afterlifeentombed.util.GodHoldInventory;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class GodHoldBlockEntity
extends BlockEntity
implements MenuProvider {
    private ItemStackHandler itemHandler;
    private LazyOptional<ItemStackHandler> lazyItemHandler = LazyOptional.empty();

    public GodHoldBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GODHOLD_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.itemHandler = new ItemStackHandler(GodHoldInventory.getInventorySize()){

            protected void onContentsChanged(int slot) {
                GodHoldBlockEntity.this.m_6596_();
                Level level = GodHoldBlockEntity.this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    GodHoldInventory sharedInv = GodHoldInventory.get(serverLevel);
                    sharedInv.setItem(slot, this.getStackInSlot(slot));
                }
            }

            public ItemStack getStackInSlot(int slot) {
                Level level = GodHoldBlockEntity.this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    GodHoldInventory sharedInv = GodHoldInventory.get(serverLevel);
                    return sharedInv.getItem(slot);
                }
                return super.getStackInSlot(slot);
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                Level level = GodHoldBlockEntity.this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    GodHoldInventory sharedInv = GodHoldInventory.get(serverLevel);
                    sharedInv.setItem(slot, stack);
                } else {
                    super.setStackInSlot(slot, stack);
                }
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                Level level = GodHoldBlockEntity.this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    GodHoldInventory sharedInv = GodHoldInventory.get(serverLevel);
                    ItemStack currentStack = sharedInv.getItem(slot);
                    if (currentStack.m_41619_() || amount <= 0) {
                        return ItemStack.f_41583_;
                    }
                    int extractAmount = Math.min(amount, currentStack.m_41613_());
                    ItemStack result = currentStack.m_41777_();
                    result.m_41764_(extractAmount);
                    if (!simulate) {
                        ItemStack remaining = currentStack.m_41777_();
                        remaining.m_41774_(extractAmount);
                        sharedInv.setItem(slot, remaining.m_41619_() ? ItemStack.f_41583_ : remaining);
                    }
                    return result;
                }
                return super.extractItem(slot, amount, simulate);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                Level level = GodHoldBlockEntity.this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    GodHoldInventory sharedInv = GodHoldInventory.get(serverLevel);
                    ItemStack currentStack = sharedInv.getItem(slot);
                    if (stack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    if (!currentStack.m_41619_() && !ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)stack)) {
                        return stack;
                    }
                    int currentCount = currentStack.m_41619_() ? 0 : currentStack.m_41613_();
                    int maxStackSize = Math.min(this.getSlotLimit(slot), stack.m_41741_());
                    int insertAmount = Math.min(stack.m_41613_(), maxStackSize - currentCount);
                    if (insertAmount <= 0) {
                        return stack;
                    }
                    if (!simulate) {
                        ItemStack newStack = stack.m_41777_();
                        newStack.m_41764_(currentCount + insertAmount);
                        sharedInv.setItem(slot, newStack);
                    }
                    ItemStack remainder = stack.m_41777_();
                    remainder.m_41774_(insertAmount);
                    return remainder.m_41619_() ? ItemStack.f_41583_ : remainder;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.afterlifeentombed.godhold");
    }

    public AbstractContainerMenu m_7208_(int pContainerId, @Nonnull Inventory pPlayerInventory, @Nonnull Player pPlayer) {
        return new GodHoldMenu(pContainerId, pPlayerInventory, this);
    }

    private GodHoldInventory getSharedInventory() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return GodHoldInventory.get(serverLevel);
        }
        return null;
    }

    public NonNullList<ItemStack> getItems() {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            return sharedInv.getSharedInventory();
        }
        return NonNullList.m_122780_((int)GodHoldInventory.getInventorySize(), (Object)ItemStack.f_41583_);
    }

    public void setItems(NonNullList<ItemStack> items) {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            sharedInv.setSharedInventory(items);
        }
    }

    public ItemStack getItem(int index) {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            return sharedInv.getItem(index);
        }
        return ItemStack.f_41583_;
    }

    public void setItem(int index, ItemStack stack) {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            sharedInv.setItem(index, stack);
            this.m_6596_();
        }
    }

    public ItemStack removeItem(int index, int count) {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            ItemStack result = sharedInv.removeItem(index, count);
            this.m_6596_();
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack removeItemNoUpdate(int index) {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            ItemStack result = sharedInv.removeItemNoUpdate(index);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean isEmpty() {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            return sharedInv.isEmpty();
        }
        return true;
    }

    public void clearContent() {
        GodHoldInventory sharedInv = this.getSharedInventory();
        if (sharedInv != null) {
            sharedInv.clearContent();
            this.m_6596_();
        }
    }

    public int getContainerSize() {
        return GodHoldInventory.getInventorySize();
    }

    public void dropContents() {
        Level currentLevel = this.f_58857_;
        if (currentLevel != null && !currentLevel.m_5776_()) {
            NonNullList<ItemStack> items = this.getItems();
            for (ItemStack stack : items) {
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)currentLevel, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
            }
            this.clearContent();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }
}

