/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.capabilities;

import com.dracolich777.afterlifeentombed.items.GodType;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GodAvatarCapability {
    public static Capability<IGodAvatar> GOD_AVATAR_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGodAvatar>(){});

    public static class GodAvatarProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final GodAvatar godAvatar = new GodAvatar();
        private final LazyOptional<IGodAvatar> optional = LazyOptional.of(() -> this.godAvatar);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == GOD_AVATAR_CAPABILITY) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.godAvatar.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.godAvatar.deserializeNBT(nbt);
        }

        public void invalidate() {
            this.optional.invalidate();
        }
    }

    public static class GodAvatar
    implements IGodAvatar {
        private GodType selectedGod = GodType.SETH;
        private long oneWithChaosCooldown = 0L;
        private int oneWithChaosTimeUsed = 0;
        private boolean oneWithChaosActive = false;
        private long damageNegationCooldown = 0L;
        private boolean damageNegationActive = false;
        private float storedDamage = 0.0f;
        private long desertWalkerCooldown = 0L;
        private boolean desertWalkerFlying = false;
        private long chaosIncarnateCooldown = 0L;
        private boolean chaosIncarnateActive = false;

        @Override
        public GodType getSelectedGod() {
            return this.selectedGod;
        }

        @Override
        public void setSelectedGod(GodType god) {
            this.selectedGod = god;
        }

        @Override
        public long getOneWithChaosCooldown() {
            return this.oneWithChaosCooldown;
        }

        @Override
        public void setOneWithChaosCooldown(long cooldown) {
            this.oneWithChaosCooldown = cooldown;
        }

        @Override
        public int getOneWithChaosTimeUsed() {
            return this.oneWithChaosTimeUsed;
        }

        @Override
        public void setOneWithChaosTimeUsed(int time) {
            this.oneWithChaosTimeUsed = time;
        }

        @Override
        public boolean isOneWithChaosActive() {
            return this.oneWithChaosActive;
        }

        @Override
        public void setOneWithChaosActive(boolean active) {
            this.oneWithChaosActive = active;
        }

        @Override
        public long getDamageNegationCooldown() {
            return this.damageNegationCooldown;
        }

        @Override
        public void setDamageNegationCooldown(long cooldown) {
            this.damageNegationCooldown = cooldown;
        }

        @Override
        public boolean isDamageNegationActive() {
            return this.damageNegationActive;
        }

        @Override
        public void setDamageNegationActive(boolean active) {
            this.damageNegationActive = active;
        }

        @Override
        public float getStoredDamage() {
            return this.storedDamage;
        }

        @Override
        public void setStoredDamage(float damage) {
            this.storedDamage = damage;
        }

        @Override
        public long getDesertWalkerCooldown() {
            return this.desertWalkerCooldown;
        }

        @Override
        public void setDesertWalkerCooldown(long cooldown) {
            this.desertWalkerCooldown = cooldown;
        }

        @Override
        public boolean isDesertWalkerFlying() {
            return this.desertWalkerFlying;
        }

        @Override
        public void setDesertWalkerFlying(boolean flying) {
            this.desertWalkerFlying = flying;
        }

        @Override
        public long getChaosIncarnateCooldown() {
            return this.chaosIncarnateCooldown;
        }

        @Override
        public void setChaosIncarnateCooldown(long cooldown) {
            this.chaosIncarnateCooldown = cooldown;
        }

        @Override
        public boolean isChaosIncarnateActive() {
            return this.chaosIncarnateActive;
        }

        @Override
        public void setChaosIncarnateActive(boolean active) {
            this.chaosIncarnateActive = active;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("SelectedGod", this.selectedGod.name());
            nbt.m_128356_("OneWithChaosCooldown", this.oneWithChaosCooldown);
            nbt.m_128405_("OneWithChaosTimeUsed", this.oneWithChaosTimeUsed);
            nbt.m_128379_("OneWithChaosActive", this.oneWithChaosActive);
            nbt.m_128356_("DamageNegationCooldown", this.damageNegationCooldown);
            nbt.m_128379_("DamageNegationActive", this.damageNegationActive);
            nbt.m_128350_("StoredDamage", this.storedDamage);
            nbt.m_128356_("DesertWalkerCooldown", this.desertWalkerCooldown);
            nbt.m_128379_("DesertWalkerFlying", this.desertWalkerFlying);
            nbt.m_128356_("ChaosIncarnateCooldown", this.chaosIncarnateCooldown);
            nbt.m_128379_("ChaosIncarnateActive", this.chaosIncarnateActive);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            try {
                this.selectedGod = GodType.valueOf(nbt.m_128461_("SelectedGod"));
            }
            catch (IllegalArgumentException e) {
                this.selectedGod = GodType.SETH;
            }
            this.oneWithChaosCooldown = nbt.m_128454_("OneWithChaosCooldown");
            this.oneWithChaosTimeUsed = nbt.m_128451_("OneWithChaosTimeUsed");
            this.oneWithChaosActive = nbt.m_128471_("OneWithChaosActive");
            this.damageNegationCooldown = nbt.m_128454_("DamageNegationCooldown");
            this.damageNegationActive = nbt.m_128471_("DamageNegationActive");
            this.storedDamage = nbt.m_128457_("StoredDamage");
            this.desertWalkerCooldown = nbt.m_128454_("DesertWalkerCooldown");
            this.desertWalkerFlying = nbt.m_128471_("DesertWalkerFlying");
            this.chaosIncarnateCooldown = nbt.m_128454_("ChaosIncarnateCooldown");
            this.chaosIncarnateActive = nbt.m_128471_("ChaosIncarnateActive");
        }
    }

    public static interface IGodAvatar {
        public GodType getSelectedGod();

        public void setSelectedGod(GodType var1);

        public long getOneWithChaosCooldown();

        public void setOneWithChaosCooldown(long var1);

        public int getOneWithChaosTimeUsed();

        public void setOneWithChaosTimeUsed(int var1);

        public boolean isOneWithChaosActive();

        public void setOneWithChaosActive(boolean var1);

        public long getDamageNegationCooldown();

        public void setDamageNegationCooldown(long var1);

        public boolean isDamageNegationActive();

        public void setDamageNegationActive(boolean var1);

        public float getStoredDamage();

        public void setStoredDamage(float var1);

        public long getDesertWalkerCooldown();

        public void setDesertWalkerCooldown(long var1);

        public boolean isDesertWalkerFlying();

        public void setDesertWalkerFlying(boolean var1);

        public long getChaosIncarnateCooldown();

        public void setChaosIncarnateCooldown(long var1);

        public boolean isChaosIncarnateActive();

        public void setChaosIncarnateActive(boolean var1);

        public CompoundTag serializeNBT();

        public void deserializeNBT(CompoundTag var1);
    }
}

