/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.client;

import com.dracolich777.afterlifeentombed.effects.MirageEffect;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="afterlifeentombed", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientMirageHandler {
    private static final Map<BlockPos, MirageBlock> MIRAGE_BLOCKS = new HashMap<BlockPos, MirageBlock>();
    private static long lastUpdateTime = 0L;
    private static final float HAZE_INTENSITY = 0.25f;
    private static final float HAZE_SPEED = 0.06f;
    private static final int HAZE_LAYERS = 3;
    private static final float HORIZON_DISTORTION_DISTANCE = 45.0f;
    private static final float MAX_DISTORTION_HEIGHT = 6.0f;

    public static void handleMirageData(List<MirageEffect.MirageData> mirageDataList) {
        for (MirageEffect.MirageData data : mirageDataList) {
            if (data.shouldRemove) {
                MIRAGE_BLOCKS.clear();
                continue;
            }
            if (data.shouldFade) {
                for (MirageBlock mirage : MIRAGE_BLOCKS.values()) {
                    mirage.startFading();
                }
                continue;
            }
            MIRAGE_BLOCKS.put(data.pos, new MirageBlock(data.pos, data.blockState, data.amplifier, data.isPhantomStructure, data.structureName));
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            ClientMirageHandler.renderMirages(event.getPoseStack(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), event.getPartialTick());
        }
    }

    private static void renderMirages(PoseStack poseStack, MultiBufferSource bufferSource, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || MIRAGE_BLOCKS.isEmpty()) {
            return;
        }
        Level level = player.m_9236_();
        Vec3 cameraPos = minecraft.f_91063_.m_109153_().m_90583_();
        Vec3 playerEyePos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 lookDirection = player.m_20154_();
        ClientMirageHandler.updateMirageStates(player, lookDirection, playerEyePos, partialTick);
        Iterator<Map.Entry<BlockPos, MirageBlock>> iterator = MIRAGE_BLOCKS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, MirageBlock> entry = iterator.next();
            MirageBlock mirage = entry.getValue();
            if (mirage.fadeAlpha <= 0.01f || mirage.ticksExisted > 8000) {
                iterator.remove();
                continue;
            }
            if (!level.m_8055_(mirage.pos).m_60795_()) {
                iterator.remove();
                continue;
            }
            ClientMirageHandler.renderMirageBlock(poseStack, bufferSource, mirage, cameraPos, partialTick);
            if (mirage.isPhantomStructure) {
                ClientMirageHandler.renderPhantomStructureEffects(poseStack, bufferSource, mirage, cameraPos, playerEyePos, partialTick);
                continue;
            }
            ClientMirageHandler.renderHeatHaze(poseStack, bufferSource, mirage, cameraPos, playerEyePos, partialTick);
        }
    }

    private static void renderHorizonDistortion(PoseStack poseStack, MultiBufferSource bufferSource, LocalPlayer player, Vec3 lookDirection, Vec3 playerEyePos, Vec3 cameraPos, float partialTick) {
        if (!player.m_21023_(MobEffects.f_19610_) && !MIRAGE_BLOCKS.isEmpty()) {
            Level level = player.m_9236_();
            for (int angle = 0; angle < 360; angle += 20) {
                double radians = Math.toRadians(angle);
                double distortionX = playerEyePos.f_82479_ + Math.cos(radians) * 45.0;
                double distortionZ = playerEyePos.f_82481_ + Math.sin(radians) * 45.0;
                double distortionY = playerEyePos.f_82480_;
                Vec3 toDistortion = new Vec3(distortionX - playerEyePos.f_82479_, 0.0, distortionZ - playerEyePos.f_82481_).m_82541_();
                double dotProduct = lookDirection.m_82526_(toDistortion);
                if (!(dotProduct > -0.2)) continue;
                ClientMirageHandler.renderHorizonHaze(poseStack, bufferSource, new Vec3(distortionX, distortionY, distortionZ), cameraPos, partialTick);
            }
        }
    }

    private static void renderHorizonHaze(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 position, Vec3 cameraPos, float partialTick) {
        poseStack.m_85836_();
        poseStack.m_85837_(position.f_82479_ - cameraPos.f_82479_, position.f_82480_ - cameraPos.f_82480_, position.f_82481_ - cameraPos.f_82481_);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110466_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        long gameTime = System.currentTimeMillis();
        float time = (float)(gameTime % 10000L) / 1000.0f;
        int rings = 6;
        float maxRadius = 15.0f;
        for (int ring = 0; ring < rings; ++ring) {
            float ringRadius = (float)(ring + 1) * (maxRadius / (float)rings);
            float ringAlpha = 0.075f / (float)(ring + 1);
            int segments = Math.max(16, (int)(ringRadius * 2.0f));
            for (int i = 0; i < segments; ++i) {
                float angle1 = (float)((double)(i * 2) * Math.PI / (double)segments);
                float angle2 = (float)((double)((i + 1) * 2) * Math.PI / (double)segments);
                float wave1 = 0.08f * (float)Math.sin(time * 1.5f + ringRadius * 0.1f + angle1 * 3.0f);
                float wave2 = 0.05f * (float)Math.sin(time * 2.8f + ringRadius * 0.15f + angle1 * 5.0f);
                float wave3 = 0.03f * (float)Math.sin(time * 4.2f + ringRadius * 0.2f + angle1 * 7.0f);
                float totalWave = wave1 + wave2 + wave3;
                float innerRadius = ringRadius - 1.0f + totalWave;
                float outerRadius = ringRadius + 1.0f + totalWave * 0.8f;
                float x1 = (float)Math.cos(angle1);
                float z1 = (float)Math.sin(angle1);
                float x2 = (float)Math.cos(angle2);
                float z2 = (float)Math.sin(angle2);
                float baseHeight = 2.4f;
                float heightVariation = baseHeight * 0.2f * (float)Math.sin(time * 1.2f + ringRadius * 0.1f);
                float topHeight = baseHeight + heightVariation;
                float bottomHeight = -baseHeight * 0.5f + heightVariation * 0.3f;
                float heatIntensity = 0.9f + 0.1f * (float)Math.sin(time * 3.0f + angle1 + ringRadius * 0.1f);
                float r = 0.98f + 0.02f * heatIntensity;
                float g = 0.99f + 0.01f * heatIntensity;
                float b = 1.0f;
                float centerAlpha = ringAlpha * 0.8f;
                float edgeAlpha = ringAlpha * 0.1f;
                consumer.m_252986_(matrix, x1 * innerRadius, bottomHeight, z1 * innerRadius).m_85950_(r, g, b, edgeAlpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, x2 * innerRadius, bottomHeight, z2 * innerRadius).m_85950_(r, g, b, edgeAlpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, x2 * outerRadius, topHeight, z2 * outerRadius).m_85950_(r, g, b, centerAlpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, x1 * outerRadius, topHeight, z1 * outerRadius).m_85950_(r, g, b, centerAlpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
        poseStack.m_85849_();
    }

    private static void renderPhantomStructureEffects(PoseStack poseStack, MultiBufferSource bufferSource, MirageBlock mirage, Vec3 cameraPos, Vec3 playerEyePos, float partialTick) {
        poseStack.m_85836_();
        Vec3 blockPos = Vec3.m_82528_((Vec3i)mirage.pos);
        poseStack.m_85837_(blockPos.f_82479_ - cameraPos.f_82479_, blockPos.f_82480_ - cameraPos.f_82480_, blockPos.f_82481_ - cameraPos.f_82481_);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110466_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        long gameTime = System.currentTimeMillis();
        float time = (float)(gameTime % 8000L) / 1000.0f;
        int rings = 3;
        for (int ring = 0; ring < rings; ++ring) {
            float ringRadius = 1.2f + (float)ring * 0.6f;
            float ringAlpha = 0.25f * mirage.fadeAlpha * 0.6f / (float)(ring + 1);
            float rotationOffset = time * 0.5f + (float)ring * 0.8f;
            int segments = 20 + ring * 6;
            for (int i = 0; i < segments; ++i) {
                float angle1 = (float)((double)(i * 2) * Math.PI / (double)segments) + rotationOffset;
                float angle2 = (float)((double)((i + 1) * 2) * Math.PI / (double)segments) + rotationOffset;
                float pulse = 0.9f + 0.1f * (float)Math.sin(time * 2.0f + (float)ring + (float)i * 0.15f);
                float wispHeight = 2.0f + (float)ring * 0.2f;
                float waveOffset = 0.05f * (float)Math.sin(time * 3.0f + angle1 * 4.0f + (float)ring);
                float x1 = (float)(Math.cos(angle1) * (double)(ringRadius + waveOffset) * (double)pulse);
                float z1 = (float)(Math.sin(angle1) * (double)(ringRadius + waveOffset) * (double)pulse);
                float x2 = (float)(Math.cos(angle2) * (double)(ringRadius + waveOffset) * (double)pulse);
                float z2 = (float)(Math.sin(angle2) * (double)(ringRadius + waveOffset) * (double)pulse);
                float colorVariation = 0.05f * (float)Math.sin(time * 1.5f + (float)ring + angle1);
                float r = 0.85f + colorVariation;
                float g = 0.92f + colorVariation * 0.5f;
                float b = 0.98f + colorVariation * 0.2f;
                float bottomAlpha = ringAlpha * 0.6f;
                float topAlpha = ringAlpha * 0.1f;
                consumer.m_252986_(matrix, x1, 0.0f, z1).m_85950_(r, g, b, bottomAlpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, x2, 0.0f, z2).m_85950_(r, g, b, bottomAlpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                float topX1 = x1 * 0.85f + 0.05f * (float)Math.sin(time * 2.5f + (float)i);
                float topZ1 = z1 * 0.85f + 0.05f * (float)Math.cos(time * 2.5f + (float)i);
                float topX2 = x2 * 0.85f + 0.05f * (float)Math.sin(time * 2.5f + (float)i + 0.3f);
                float topZ2 = z2 * 0.85f + 0.05f * (float)Math.cos(time * 2.5f + (float)i + 0.3f);
                consumer.m_252986_(matrix, topX2, wispHeight, topZ2).m_85950_(r, g, b, topAlpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, topX1, wispHeight, topZ1).m_85950_(r, g, b, topAlpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
        poseStack.m_85849_();
    }

    private static void updateMirageStates(LocalPlayer player, Vec3 lookDirection, Vec3 playerEyePos, float partialTick) {
        long currentTime = System.currentTimeMillis();
        for (MirageBlock mirage : MIRAGE_BLOCKS.values()) {
            boolean currentlyLookingDirectly;
            ++mirage.ticksExisted;
            Vec3 mirageCenter = Vec3.m_82512_((Vec3i)mirage.pos);
            Vec3 toMirage = mirageCenter.m_82546_(playerEyePos).m_82541_();
            double dotProduct = lookDirection.m_82526_(toMirage);
            double distance = playerEyePos.m_82554_(mirageCenter);
            boolean bl = currentlyLookingDirectly = dotProduct > 0.9 && distance < 55.0;
            if (currentlyLookingDirectly) {
                mirage.isBeingLookedAt = true;
                mirage.fadeAlpha = Math.max(0.0f, mirage.fadeAlpha - 0.04f);
            } else {
                mirage.isBeingLookedAt = false;
                mirage.fadeAlpha = mirage.isFading ? Math.max(0.0f, mirage.fadeAlpha - mirage.fadeSpeed) : Math.min(1.0f, mirage.fadeAlpha + 0.015f);
            }
            mirage.hazePhase += 0.06f * partialTick;
            if (!((double)mirage.hazePhase > Math.PI * 2)) continue;
            mirage.hazePhase = (float)((double)mirage.hazePhase - Math.PI * 2);
        }
    }

    private static void renderMirageBlock(PoseStack poseStack, MultiBufferSource bufferSource, MirageBlock mirage, Vec3 cameraPos, float partialTick) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        poseStack.m_85836_();
        Vec3 blockPos = Vec3.m_82528_((Vec3i)mirage.pos);
        poseStack.m_85837_(blockPos.f_82479_ - cameraPos.f_82479_, blockPos.f_82480_ - cameraPos.f_82480_, blockPos.f_82481_ - cameraPos.f_82481_);
        float shimmerIntensity = 0.1f + 0.05f * (float)Math.sin(mirage.hazePhase * 2.0f);
        float alpha = mirage.fadeAlpha * (0.7f + shimmerIntensity);
        if (mirage.isPhantomStructure) {
            alpha *= 0.6f;
            shimmerIntensity *= 1.5f;
        }
        float waveX = 0.02f * (float)Math.sin(mirage.hazePhase + mirage.hazeOffset);
        float waveZ = 0.02f * (float)Math.cos(mirage.hazePhase * 1.3f + mirage.hazeOffset);
        poseStack.m_252880_(waveX, 0.0f, waveZ);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110466_());
        ClientMirageHandler.renderBlockWithAlpha(poseStack, consumer, mirage.blockState, alpha);
        poseStack.m_85849_();
    }

    private static void renderBlockWithAlpha(PoseStack poseStack, VertexConsumer consumer, BlockState blockState, float alpha) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        try {
            BakedModel model = blockRenderer.m_110910_(blockState);
            AlphaVertexConsumer alphaConsumer = new AlphaVertexConsumer(consumer, alpha);
            blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), (VertexConsumer)alphaConsumer, blockState, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
        }
        catch (Exception e) {
            ClientMirageHandler.renderSimpleCube(poseStack, consumer, alpha);
        }
    }

    private static void renderSimpleCube(PoseStack poseStack, VertexConsumer consumer, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int light = 0xF000F0;
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        consumer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void renderHeatHaze(PoseStack poseStack, MultiBufferSource bufferSource, MirageBlock mirage, Vec3 cameraPos, Vec3 playerEyePos, float partialTick) {
        double distanceToMirage = playerEyePos.m_82554_(Vec3.m_82512_((Vec3i)mirage.pos));
        if (mirage.amplifier != 1 && distanceToMirage > 30.0) {
            return;
        }
        poseStack.m_85836_();
        Vec3 blockPos = Vec3.m_82528_((Vec3i)mirage.pos);
        poseStack.m_85837_(blockPos.f_82479_ - cameraPos.f_82479_, blockPos.f_82480_ - cameraPos.f_82480_, blockPos.f_82481_ - cameraPos.f_82481_);
        for (int layer = 0; layer < 3; ++layer) {
            float layerOffset = (float)(layer + 1) * 0.5f;
            float layerAlpha = 0.25f * mirage.fadeAlpha * (1.0f - (float)layer * 0.3f);
            ClientMirageHandler.renderHazeLayer(poseStack, bufferSource, mirage, layerOffset, layerAlpha, partialTick);
        }
        poseStack.m_85849_();
    }

    private static void renderHazeLayer(PoseStack poseStack, MultiBufferSource bufferSource, MirageBlock mirage, float offset, float alpha, float partialTick) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110466_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float time = mirage.hazePhase + mirage.hazeOffset;
        int segments = 16;
        float radius = 1.0f + offset;
        float height = 2.0f;
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)((double)(i * 2) * Math.PI / (double)segments);
            float angle2 = (float)((double)((i + 1) * 2) * Math.PI / (double)segments);
            float waveOffset1 = 0.05f * (float)Math.sin(time * 1.8f + angle1 * 2.0f);
            float waveOffset2 = 0.05f * (float)Math.sin(time * 1.8f + angle2 * 2.0f);
            float x1 = (float)(Math.cos(angle1) * (double)(radius + waveOffset1));
            float z1 = (float)(Math.sin(angle1) * (double)(radius + waveOffset1));
            float x2 = (float)(Math.cos(angle2) * (double)(radius + waveOffset2));
            float z2 = (float)(Math.sin(angle2) * (double)(radius + waveOffset2));
            float colorShift = 0.02f * (float)Math.sin(time * 0.8f + angle1);
            float r = 0.96f + colorShift;
            float g = 0.98f + colorShift * 0.5f;
            float b = 1.0f;
            float bottomAlpha = alpha * 0.4f;
            float topAlpha = alpha * 0.05f;
            consumer.m_252986_(matrix, x1, 0.0f, z1).m_85950_(r, g, b, bottomAlpha).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix, x2, 0.0f, z2).m_85950_(r, g, b, bottomAlpha).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            float topWave1 = 0.03f * (float)Math.sin(time * 2.2f + angle1 * 1.5f);
            float topWave2 = 0.03f * (float)Math.sin(time * 2.2f + angle2 * 1.5f);
            consumer.m_252986_(matrix, x2 + topWave2, height, z2 + topWave2).m_85950_(r, g, b, topAlpha).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix, x1 + topWave1, height, z1 + topWave1).m_85950_(r, g, b, topAlpha).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    public static void clearAllMirages() {
        MIRAGE_BLOCKS.clear();
    }

    public static class MirageBlock {
        public final BlockPos pos;
        public final BlockState blockState;
        public final int amplifier;
        public float fadeAlpha;
        public boolean isBeingLookedAt;
        public int ticksExisted;
        public float hazeOffset;
        public float hazePhase;
        public final boolean isPhantomStructure;
        public final String structureName;
        public boolean isFading;
        public float fadeSpeed;

        public MirageBlock(BlockPos pos, BlockState blockState, int amplifier) {
            this(pos, blockState, amplifier, false, "");
        }

        public MirageBlock(BlockPos pos, BlockState blockState, int amplifier, boolean isPhantomStructure, String structureName) {
            this.pos = pos;
            this.blockState = blockState;
            this.amplifier = amplifier;
            this.fadeAlpha = 1.0f;
            this.isBeingLookedAt = false;
            this.ticksExisted = 0;
            this.hazeOffset = (float)(Math.random() * Math.PI * 2.0);
            this.hazePhase = (float)(Math.random() * Math.PI * 2.0);
            this.isPhantomStructure = isPhantomStructure;
            this.structureName = structureName != null ? structureName : "";
            this.isFading = false;
            this.fadeSpeed = 0.02f;
        }

        public void startFading() {
            this.isFading = true;
            this.fadeSpeed = 0.015f;
        }
    }

    private static class AlphaVertexConsumer
    implements VertexConsumer {
        private final VertexConsumer delegate;
        private final float alpha;

        public AlphaVertexConsumer(VertexConsumer delegate, float alpha) {
            this.delegate = delegate;
            this.alpha = alpha;
        }

        public VertexConsumer m_5483_(double x, double y, double z) {
            return this.delegate.m_5483_(x, y, z);
        }

        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return this.delegate.m_6122_(red, green, blue, (int)((float)alpha * this.alpha));
        }

        public VertexConsumer m_85950_(float red, float green, float blue, float alpha) {
            return this.delegate.m_85950_(red, green, blue, alpha * this.alpha);
        }

        public VertexConsumer m_7421_(float u, float v) {
            return this.delegate.m_7421_(u, v);
        }

        public VertexConsumer m_7122_(int u, int v) {
            return this.delegate.m_7122_(u, v);
        }

        public VertexConsumer m_7120_(int u, int v) {
            return this.delegate.m_7120_(u, v);
        }

        public VertexConsumer m_5601_(float x, float y, float z) {
            return this.delegate.m_5601_(x, y, z);
        }

        public void m_5752_() {
            this.delegate.m_5752_();
        }

        public void m_7404_(int red, int green, int blue, int alpha) {
            this.delegate.m_7404_(red, green, blue, (int)((float)alpha * this.alpha));
        }

        public void m_141991_() {
            this.delegate.m_141991_();
        }
    }
}

