/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.client;

import com.dracolich777.afterlifeentombed.init.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="afterlifeentombed", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CrownClientHandler {
    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        boolean hasCrown = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CROWN_OF_SETH.get(), (LivingEntity)player).isPresent();
        if (hasCrown) {
            boolean shouldBeInvisible = true;
            CompoundTag entityData = player.getPersistentData();
            if (entityData.m_128471_("crown_invisibility_pending")) {
                long equipTime = entityData.m_128454_("crown_equip_time");
                long currentTime = player.m_9236_().m_46467_();
                if (currentTime - equipTime < 60L) {
                    shouldBeInvisible = false;
                }
            }
            if (shouldBeInvisible) {
                if (player.m_20148_().equals(clientPlayer.m_20148_())) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        boolean hasCrown = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CROWN_OF_SETH.get(), (LivingEntity)player).isPresent();
        if (hasCrown) {
            boolean shouldBeInvisible = true;
            CompoundTag entityData = player.getPersistentData();
            if (entityData.m_128471_("crown_invisibility_pending")) {
                long equipTime = entityData.m_128454_("crown_equip_time");
                long currentTime = player.m_9236_().m_46467_();
                if (currentTime - equipTime < 60L) {
                    shouldBeInvisible = false;
                }
            }
            if (shouldBeInvisible && player.m_20148_().equals(clientPlayer.m_20148_())) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            }
        }
    }
}

