/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.client;

import com.dracolich777.afterlifeentombed.init.ModEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="afterlifeentombed", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class HolyFireOverlay {
    private static final ResourceLocation HOLY_FIRE_OVERLAY_TEXTURE = new ResourceLocation("afterlifeentombed", "textures/gui/fire_1.png");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderGuiPre(RenderGuiEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.f_91074_.m_21023_((MobEffect)ModEffects.HOLY_FIRE.get()) && minecraft.f_91066_.m_92176_().m_90612_()) {
            HolyFireOverlay.renderHolyFireScreenOverlay(event.getGuiGraphics(), minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_());
        }
    }

    private static void renderHolyFireScreenOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HOLY_FIRE_OVERLAY_TEXTURE);
        long gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
        int frameCount = 32;
        int currentFrame = (int)(gameTime / 1L % (long)frameCount);
        int fireHeight = screenHeight;
        boolean fireY = false;
        float minV = (float)currentFrame / (float)frameCount;
        float maxV = (float)(currentFrame + 1) / (float)frameCount;
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, maxV).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, maxV).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)screenWidth, (float)fireY, 0.0f).m_7421_(1.0f, minV).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, (float)fireY, 0.0f).m_7421_(0.0f, minV).m_5752_();
        BufferBuilder.RenderedBuffer renderedBuffer = bufferBuilder.m_231175_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderedBuffer);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }
}

