/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.client.renderer;

import com.dracolich777.afterlifeentombed.mobs.ShabtiEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ShabtiEntityRenderer
extends LivingEntityRenderer<ShabtiEntity, HumanoidModel<ShabtiEntity>> {
    public ShabtiEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HumanoidModel(context.m_174023_(ModelLayers.f_171162_)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public void render(ShabtiEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ((HumanoidModel)this.f_115290_).m_8009_(true);
        if (entity.hasDisplayFlag(4)) {
            entity.m_146922_(entity.getOwnerYaw());
            entity.m_146926_(entity.getOwnerPitch());
            entity.m_5616_(entity.getOwnerYawHead());
        }
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        String statusInfo = entity.getOwnerStatusInfo();
        if (!statusInfo.isEmpty()) {
            this.renderStatusText(entity, statusInfo, poseStack, buffer, packedLight);
        }
    }

    private void renderStatusText(ShabtiEntity entity, String statusInfo, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)entity.m_20206_() + 0.8, 0.0);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        String[] lines = statusInfo.split("\n");
        int lineHeight = 10;
        int totalHeight = lines.length * lineHeight;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int yOffset = i * lineHeight - totalHeight / 2;
            int textWidth = this.m_114481_().m_92895_(line);
            this.m_114481_().m_271703_(line, (float)(-textWidth) / 2.0f, (float)yOffset, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0x40000000, packedLight);
        }
        poseStack.m_85849_();
    }

    protected RenderType getRenderType(ShabtiEntity entity, boolean bodyVisible, boolean translucent, boolean glowing) {
        ResourceLocation textureLocation = this.getTextureLocation(entity);
        if (translucent) {
            return RenderType.m_110473_((ResourceLocation)textureLocation);
        }
        if (bodyVisible) {
            return RenderType.m_110473_((ResourceLocation)textureLocation);
        }
        return null;
    }

    public ResourceLocation getTextureLocation(ShabtiEntity entity) {
        Player owner;
        UUID ownerUUID = entity.getOwnerUUID();
        if (ownerUUID != null && (owner = Minecraft.m_91087_().f_91073_.m_46003_(ownerUUID)) instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)owner;
            return clientPlayer.m_108560_();
        }
        return DefaultPlayerSkin.m_118626_();
    }
}

