/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.effects;

import com.dracolich777.afterlifeentombed.client.ClientMirageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class MirageEffect
extends MobEffect {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("afterlifeentombed", "mirage_effect"), () -> "1", "1"::equals, "1"::equals);
    private static final Map<Player, BlockPos> LAST_PLAYER_POS = new HashMap<Player, BlockPos>();
    private static final Map<Player, Vec3> LAST_LOOK_DIRECTION = new HashMap<Player, Vec3>();
    private static final Map<BlockState, Integer> TREASURE_BLOCKS = new HashMap<BlockState, Integer>();
    private static final Map<BlockState, Integer> DESERT_BLOCKS = new HashMap<BlockState, Integer>();
    private static final List<PhantomStructure> PHANTOM_STRUCTURES = new ArrayList<PhantomStructure>();
    private static final int MIRAGE_DISTANCE = 50;
    private static final int MAX_BLOCKS_PER_FORMATION = 15;
    private static final int MIN_BLOCK_SPACING = 3;
    private static final double PERIPHERAL_CREATE_THRESHOLD = 0.7;
    private static boolean networkInitialized;

    private static void initializePhantomStructures() {
        int z;
        int x;
        ArrayList<BlockPos> villagePositions = new ArrayList<BlockPos>();
        ArrayList<BlockState> villageBlocks = new ArrayList<BlockState>();
        for (int x2 = 0; x2 <= 6; ++x2) {
            for (int z2 = 0; z2 <= 6; ++z2) {
                for (int y = 0; y <= 4; ++y) {
                    if (y == 0) {
                        villagePositions.add(new BlockPos(x2, y, z2));
                        villageBlocks.add(Blocks.f_50652_.m_49966_());
                        continue;
                    }
                    if (y <= 3 && (x2 == 0 || x2 == 6 || z2 == 0 || z2 == 6)) {
                        villagePositions.add(new BlockPos(x2, y, z2));
                        villageBlocks.add(Blocks.f_50705_.m_49966_());
                        continue;
                    }
                    if (y != 4 || x2 < 1 || x2 > 5 || z2 < 1 || z2 > 5) continue;
                    villagePositions.add(new BlockPos(x2, y, z2));
                    villageBlocks.add(Blocks.f_50086_.m_49966_());
                }
            }
        }
        villagePositions.add(new BlockPos(3, 1, 0));
        villageBlocks.add(Blocks.f_50154_.m_49966_());
        villagePositions.add(new BlockPos(3, 2, 0));
        villageBlocks.add(Blocks.f_50154_.m_49966_());
        PHANTOM_STRUCTURES.add(new PhantomStructure("village_house", villagePositions, villageBlocks, 7, 5, 7));
        ArrayList<BlockPos> outpostPositions = new ArrayList<BlockPos>();
        ArrayList<BlockState> outpostBlocks = new ArrayList<BlockState>();
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 8; ++y) {
                    if (x == 0 && z == 0) {
                        outpostPositions.add(new BlockPos(x, y, z));
                        outpostBlocks.add(Blocks.f_50004_.m_49966_());
                        continue;
                    }
                    if (Math.abs(x) != 1 && Math.abs(z) != 1 || y > 6) continue;
                    outpostPositions.add(new BlockPos(x, y, z));
                    outpostBlocks.add(Blocks.f_50652_.m_49966_());
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (Math.abs(x) != 2 && Math.abs(z) != 2) continue;
                outpostPositions.add(new BlockPos(x, 9, z));
                outpostBlocks.add(Blocks.f_50745_.m_49966_());
            }
        }
        PHANTOM_STRUCTURES.add(new PhantomStructure("pillager_outpost", outpostPositions, outpostBlocks, 5, 10, 5));
        ArrayList<BlockPos> templePositions = new ArrayList<BlockPos>();
        ArrayList<BlockState> templeBlocks = new ArrayList<BlockState>();
        for (int x3 = 0; x3 <= 8; ++x3) {
            for (int z3 = 0; z3 <= 8; ++z3) {
                for (int y = 0; y <= 6; ++y) {
                    if ((x3 == 0 || x3 == 8 || z3 == 0 || z3 == 8) && y <= 4) {
                        templePositions.add(new BlockPos(x3, y, z3));
                        templeBlocks.add(Blocks.f_50062_.m_49966_());
                        continue;
                    }
                    if (x3 > 1 && x3 < 7 || z3 > 1 && z3 < 7 || y > 6) continue;
                    templePositions.add(new BlockPos(x3, y, z3));
                    templeBlocks.add(Blocks.f_50062_.m_49966_());
                }
            }
        }
        PHANTOM_STRUCTURES.add(new PhantomStructure("desert_temple", templePositions, templeBlocks, 9, 7, 9));
        ArrayList<BlockPos> hutPositions = new ArrayList<BlockPos>();
        ArrayList<BlockState> hutBlocks = new ArrayList<BlockState>();
        for (int x4 = 0; x4 <= 4; ++x4) {
            for (int z4 = 0; z4 <= 4; ++z4) {
                for (int y = 0; y <= 5; ++y) {
                    if (!(x4 != 0 && x4 != 4 || z4 != 0 && z4 != 4 || y > 3)) {
                        hutPositions.add(new BlockPos(x4, y, z4));
                        hutBlocks.add(Blocks.f_50000_.m_49966_());
                        continue;
                    }
                    if (y == 3) {
                        hutPositions.add(new BlockPos(x4, y, z4));
                        hutBlocks.add(Blocks.f_50741_.m_49966_());
                        continue;
                    }
                    if (y == 4 && (x4 == 0 || x4 == 4 || z4 == 0 || z4 == 4)) {
                        hutPositions.add(new BlockPos(x4, y, z4));
                        hutBlocks.add(Blocks.f_50741_.m_49966_());
                        continue;
                    }
                    if (y != 5 || x4 < 1 || x4 > 3 || z4 < 1 || z4 > 3) continue;
                    hutPositions.add(new BlockPos(x4, y, z4));
                    hutBlocks.add(Blocks.f_50269_.m_49966_());
                }
            }
        }
        PHANTOM_STRUCTURES.add(new PhantomStructure("witch_hut", hutPositions, hutBlocks, 5, 6, 5));
        ArrayList<BlockPos> portalPositions = new ArrayList<BlockPos>();
        ArrayList<BlockState> portalBlocks = new ArrayList<BlockState>();
        for (int x5 = 0; x5 <= 3; ++x5) {
            for (int y = 0; y <= 4; ++y) {
                if ((x5 == 0 || x5 == 3) && y >= 1 && y <= 3) {
                    portalPositions.add(new BlockPos(x5, y, 0));
                    if (y == 2 && x5 == 0) {
                        portalBlocks.add(Blocks.f_50016_.m_49966_());
                    } else {
                        portalBlocks.add(Blocks.f_50080_.m_49966_());
                    }
                }
                if (y != 0 && y != 4 || x5 < 1 || x5 > 2) continue;
                portalPositions.add(new BlockPos(x5, y, 0));
                portalBlocks.add(Blocks.f_50080_.m_49966_());
            }
        }
        portalPositions.add(new BlockPos(1, 0, 0));
        portalBlocks.add(Blocks.f_50723_.m_49966_());
        PHANTOM_STRUCTURES.add(new PhantomStructure("ruined_portal", portalPositions, portalBlocks, 4, 5, 1));
    }

    public MirageEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
        MirageEffect.initializeNetwork();
    }

    private static synchronized void initializeNetwork() {
        if (!networkInitialized) {
            try {
                NETWORK.registerMessage(0, MirageDataPacket.class, MirageDataPacket::encode, MirageDataPacket::decode, MirageDataPacket::handle);
                networkInitialized = true;
            }
            catch (Exception e) {
                System.err.println("Failed to initialize MirageEffect network: " + e.getMessage());
            }
        }
    }

    public static void removeAllMirages(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            try {
                ArrayList<MirageData> clearData = new ArrayList<MirageData>();
                clearData.add(new MirageData(BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), 0, true));
                NETWORK.sendTo((Object)new MirageDataPacket(clearData), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            catch (Exception e) {
                System.err.println("Error removing mirages for player: " + e.getMessage());
            }
        }
        MirageEffect.cleanupPlayer(player);
    }

    public void m_6742_(@Nonnull LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity == null || pLivingEntity.m_9236_() == null) {
            return;
        }
        if (pLivingEntity.m_9236_().m_5776_()) {
            return;
        }
        if (pLivingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pLivingEntity;
            try {
                boolean shouldCreateMirages;
                Vec3 lookAngle;
                boolean playerMoved;
                Level level = serverPlayer.m_9236_();
                if (level == null) {
                    return;
                }
                RandomSource random = level.f_46441_;
                BlockPos currentPos = serverPlayer.m_20183_();
                BlockPos lastPos = LAST_PLAYER_POS.get(serverPlayer);
                boolean bl = playerMoved = lastPos == null || currentPos.m_123331_((Vec3i)lastPos) > 9.0;
                if (playerMoved) {
                    ArrayList<MirageData> fadeData = new ArrayList<MirageData>();
                    fadeData.add(new MirageData(BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), pAmplifier, false, false, "", true));
                    NETWORK.sendTo((Object)new MirageDataPacket(fadeData), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    LAST_PLAYER_POS.put((Player)serverPlayer, currentPos);
                }
                if ((lookAngle = serverPlayer.m_20154_()) != null) {
                    LAST_LOOK_DIRECTION.put((Player)serverPlayer, lookAngle);
                }
                boolean bl2 = shouldCreateMirages = pAmplifier == 1 ? this.isInDesertBiome((Player)serverPlayer) : true;
                if (shouldCreateMirages && (random.m_188503_(60) == 0 || playerMoved && random.m_188503_(100) == 0)) {
                    this.createMirage(serverPlayer, random, pAmplifier);
                }
            }
            catch (Exception e) {
                System.err.println("Error in MirageEffect.applyEffectTick: " + e.getMessage());
            }
        }
    }

    private void createMirage(ServerPlayer player, RandomSource random, int amplifier) {
        try {
            Level level = player.m_9236_();
            if (level == null) {
                return;
            }
            BlockPos playerBlockPos = player.m_20183_();
            Vec3 playerEyePos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Vec3 playerLookDirection = player.m_20154_();
            if (playerLookDirection == null) {
                return;
            }
            int formationCount = 1;
            ArrayList<MirageData> mirageDataList = new ArrayList<MirageData>();
            for (int formation = 0; formation < formationCount; ++formation) {
                double angle = (double)formation * 2.0 * Math.PI / (double)formationCount + random.m_188500_() * 0.5;
                int mirageX = playerBlockPos.m_123341_() + (int)(Math.cos(angle) * 50.0);
                int mirageZ = playerBlockPos.m_123343_() + (int)(Math.sin(angle) * 50.0);
                int mirageY = playerBlockPos.m_123342_() + random.m_188503_(3) - 1;
                BlockPos potentialMirageBlockPos = new BlockPos(mirageX, mirageY, mirageZ);
                Vec3 potentialMirageCenter = Vec3.m_82512_((Vec3i)potentialMirageBlockPos);
                Vec3 toPotentialMirage = potentialMirageCenter.m_82546_(playerEyePos).m_82541_();
                double dotProduct = playerLookDirection.m_82526_(toPotentialMirage);
                if (!(dotProduct < 0.7) || !(dotProduct > 0.0) || PHANTOM_STRUCTURES.isEmpty()) continue;
                PhantomStructure structure = this.selectBiomeAppropriateStructure((Player)player, level, random);
                List<MirageData> structureData = this.createPhantomStructure(player, potentialMirageBlockPos, structure, random, amplifier);
                mirageDataList.addAll(structureData);
            }
            if (!mirageDataList.isEmpty()) {
                NETWORK.sendTo((Object)new MirageDataPacket(mirageDataList), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
        catch (Exception e) {
            System.err.println("Error creating mirage: " + e.getMessage());
        }
    }

    private Map<BlockState, Integer> getAppropriateBlocks(Player player, Level level, int amplifier) {
        HashMap<BlockState, Integer> blocks = new HashMap<BlockState, Integer>();
        blocks.putAll(TREASURE_BLOCKS);
        if (level.m_46472_() == Level.f_46429_) {
            blocks.put(Blocks.f_50722_.m_49966_(), 1);
        }
        if (amplifier == 1) {
            blocks.putAll(DESERT_BLOCKS);
        }
        return blocks;
    }

    private List<MirageData> createSparseFormation(ServerPlayer player, BlockPos centerPos, Map<BlockState, Integer> blockSet, RandomSource random, int amplifier) {
        ArrayList<MirageData> mirageDataList = new ArrayList<MirageData>();
        try {
            Level level = player.m_9236_();
            if (level == null) {
                return mirageDataList;
            }
            BlockPos groundPos = this.findSolidGround(level, centerPos);
            if (groundPos == null) {
                return mirageDataList;
            }
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            int maxAttempts = 200;
            for (int attempts = 0; positions.size() < 15 && attempts < maxAttempts; ++attempts) {
                int dz;
                int searchRadius = 15 + positions.size() / 3;
                int dx = random.m_188503_(searchRadius * 2 + 1) - searchRadius;
                BlockPos candidateBase = groundPos.m_7918_(dx, 0, dz = random.m_188503_(searchRadius * 2 + 1) - searchRadius);
                BlockPos candidatePos = this.findNonFloatingPosition(level, candidateBase);
                if (candidatePos == null) continue;
                boolean validPosition = true;
                for (BlockPos existingPos : positions) {
                    double distance = Math.sqrt(candidatePos.m_123331_((Vec3i)existingPos));
                    if (!(distance < 3.0)) continue;
                    validPosition = false;
                    break;
                }
                if (!validPosition) continue;
                positions.add(candidatePos);
            }
            for (BlockPos pos : positions) {
                BlockState block = this.getRandomMirageBlock(blockSet, random);
                if (!level.m_8055_(pos).m_60795_()) continue;
                mirageDataList.add(new MirageData(pos, block, amplifier, false));
            }
        }
        catch (Exception e) {
            System.err.println("Error creating sparse formation: " + e.getMessage());
        }
        return mirageDataList;
    }

    private List<MirageData> createPhantomStructure(ServerPlayer player, BlockPos centerPos, PhantomStructure structure, RandomSource random, int amplifier) {
        ArrayList<MirageData> structureData = new ArrayList<MirageData>();
        try {
            Level level = player.m_9236_();
            if (level == null) {
                return structureData;
            }
            BlockPos groundPos = this.findSolidGround(level, centerPos);
            if (groundPos == null) {
                return structureData;
            }
            for (int i = 0; i < structure.relativePositions.size() && i < structure.blocks.size(); ++i) {
                BlockPos relativePos = structure.relativePositions.get(i);
                BlockState blockState = structure.blocks.get(i);
                BlockPos absolutePos = groundPos.m_121955_((Vec3i)relativePos);
                if (!level.m_8055_(absolutePos).m_60795_()) continue;
                structureData.add(new MirageData(absolutePos, blockState, amplifier, false, true, structure.name));
            }
        }
        catch (Exception e) {
            System.err.println("Error creating phantom structure: " + e.getMessage());
        }
        return structureData;
    }

    private BlockPos findSolidGround(Level level, BlockPos startPos) {
        try {
            for (int y = startPos.m_123342_(); y > level.m_141937_() + 5; --y) {
                BlockPos checkPos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
                BlockState blockBelow = level.m_8055_(checkPos.m_7495_());
                BlockState blockAt = level.m_8055_(checkPos);
                if (blockBelow.m_60795_() || !blockAt.m_60795_()) continue;
                return checkPos;
            }
        }
        catch (Exception e) {
            System.err.println("Error finding solid ground: " + e.getMessage());
        }
        return null;
    }

    private BlockPos findNonFloatingPosition(Level level, BlockPos startPos) {
        try {
            BlockPos groundPos = this.findSolidGround(level, startPos);
            if (groundPos == null) {
                return null;
            }
            for (int dy = 0; dy <= 5; ++dy) {
                BlockPos checkPos = groundPos.m_7918_(0, dy, 0);
                BlockState blockAt = level.m_8055_(checkPos);
                BlockState blockBelow = level.m_8055_(checkPos.m_7495_());
                if (!blockAt.m_60795_() || blockBelow.m_60795_()) continue;
                return checkPos;
            }
            return groundPos;
        }
        catch (Exception e) {
            System.err.println("Error finding non-floating position: " + e.getMessage());
            return null;
        }
    }

    private BlockState getRandomMirageBlock(Map<BlockState, Integer> blockSet, RandomSource random) {
        try {
            if (blockSet.isEmpty()) {
                return Blocks.f_50089_.m_49966_();
            }
            int totalWeight = blockSet.values().stream().mapToInt(Integer::intValue).sum();
            if (totalWeight <= 0) {
                return Blocks.f_50089_.m_49966_();
            }
            int randomValue = random.m_188503_(totalWeight);
            int currentWeight = 0;
            for (Map.Entry<BlockState, Integer> entry : blockSet.entrySet()) {
                if (randomValue >= (currentWeight += entry.getValue().intValue())) continue;
                return entry.getKey();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting random mirage block: " + e.getMessage());
        }
        return Blocks.f_50089_.m_49966_();
    }

    private boolean isInDesertBiome(Player player) {
        try {
            Level level = player.m_9236_();
            if (level == null) {
                return false;
            }
            BlockPos pos = player.m_20183_();
            Biome biome = (Biome)level.m_204166_(pos).m_203334_();
            return biome == level.m_9598_().m_175515_(Registries.f_256952_).m_6246_(Biomes.f_48203_) || biome == level.m_9598_().m_175515_(Registries.f_256952_).m_6246_(Biomes.f_48159_) || biome == level.m_9598_().m_175515_(Registries.f_256952_).m_6246_(Biomes.f_48194_) || biome == level.m_9598_().m_175515_(Registries.f_256952_).m_6246_(Biomes.f_186753_);
        }
        catch (Exception e) {
            System.err.println("Error checking desert biome: " + e.getMessage());
            return false;
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public static void cleanupPlayer(Player player) {
        try {
            LAST_PLAYER_POS.remove(player);
            LAST_LOOK_DIRECTION.remove(player);
        }
        catch (Exception e) {
            System.err.println("Error cleaning up player data: " + e.getMessage());
        }
    }

    private PhantomStructure selectBiomeAppropriateStructure(Player player, Level level, RandomSource random) {
        Biome biome = (Biome)level.m_204166_(player.m_20183_()).m_203334_();
        String biomeKey = "unknown";
        try {
            Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
            ResourceLocation resourceLocation = biomeRegistry.m_7981_((Object)biome);
            if (resourceLocation != null) {
                biomeKey = resourceLocation.toString().toLowerCase();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting biome key: " + e.getMessage());
        }
        ArrayList<PhantomStructure> appropriateStructures = new ArrayList<PhantomStructure>();
        System.out.println("Debug: Player in biome: " + biomeKey);
        if (biomeKey.contains("desert")) {
            appropriateStructures.add(this.getStructureByName("desert_temple"));
            appropriateStructures.add(this.getStructureByName("ruined_portal"));
            System.out.println("Debug: Selected desert structures");
        } else if (biomeKey.contains("plains") || biomeKey.contains("grassland")) {
            appropriateStructures.add(this.getStructureByName("village_house"));
            appropriateStructures.add(this.getStructureByName("pillager_outpost"));
            System.out.println("Debug: Selected plains structures");
        } else if (biomeKey.contains("swamp") || biomeKey.contains("marsh")) {
            appropriateStructures.add(this.getStructureByName("witch_hut"));
            appropriateStructures.add(this.getStructureByName("ruined_portal"));
            System.out.println("Debug: Selected swamp structures");
        } else if (biomeKey.contains("forest") || biomeKey.contains("taiga") || biomeKey.contains("birch") || biomeKey.contains("dark_forest")) {
            appropriateStructures.add(this.getStructureByName("pillager_outpost"));
            appropriateStructures.add(this.getStructureByName("witch_hut"));
            System.out.println("Debug: Selected forest structures");
        } else {
            appropriateStructures.add(this.getStructureByName("ruined_portal"));
            appropriateStructures.add(this.getStructureByName("village_house"));
            System.out.println("Debug: Selected fallback structures for biome: " + biomeKey);
        }
        return (PhantomStructure)appropriateStructures.get(random.m_188503_(appropriateStructures.size()));
    }

    private PhantomStructure getStructureByName(String name) {
        return PHANTOM_STRUCTURES.stream().filter(structure -> structure.name.equals(name)).findFirst().orElse(PHANTOM_STRUCTURES.get(0));
    }

    static {
        TREASURE_BLOCKS.put(Blocks.f_50089_.m_49966_(), 1);
        TREASURE_BLOCKS.put(Blocks.f_50264_.m_49966_(), 1);
        TREASURE_BLOCKS.put(Blocks.f_50062_.m_49966_(), 15);
        TREASURE_BLOCKS.put(Blocks.f_49992_.m_49966_(), 20);
        TREASURE_BLOCKS.put(Blocks.f_50471_.m_49966_(), 12);
        TREASURE_BLOCKS.put(Blocks.f_50064_.m_49966_(), 10);
        DESERT_BLOCKS.put(Blocks.f_50128_.m_49966_(), 25);
        DESERT_BLOCKS.put(Blocks.f_50440_.m_49966_(), 30);
        DESERT_BLOCKS.put(Blocks.f_49999_.m_49966_(), 10);
        DESERT_BLOCKS.put(Blocks.f_50050_.m_49966_(), 15);
        DESERT_BLOCKS.put(Blocks.f_50062_.m_49966_(), 20);
        DESERT_BLOCKS.put(Blocks.f_50063_.m_49966_(), 15);
        DESERT_BLOCKS.put(Blocks.f_50036_.m_49966_(), 20);
        DESERT_BLOCKS.put(Blocks.f_50352_.m_49966_(), 15);
        DESERT_BLOCKS.put(Blocks.f_50299_.m_49966_(), 12);
        DESERT_BLOCKS.put(Blocks.f_50288_.m_49966_(), 12);
        MirageEffect.initializePhantomStructures();
        networkInitialized = false;
    }

    public static class PhantomStructure {
        public final String name;
        public final List<BlockPos> relativePositions;
        public final List<BlockState> blocks;
        public final int width;
        public final int height;
        public final int depth;

        public PhantomStructure(String name, List<BlockPos> positions, List<BlockState> blocks, int width, int height, int depth) {
            this.name = name;
            this.relativePositions = positions;
            this.blocks = blocks;
            this.width = width;
            this.height = height;
            this.depth = depth;
        }
    }

    public static class MirageDataPacket {
        private final List<MirageData> mirageData;

        public MirageDataPacket(List<MirageData> mirageData) {
            this.mirageData = mirageData != null ? mirageData : new ArrayList();
        }

        public static void encode(MirageDataPacket packet, FriendlyByteBuf buf) {
            try {
                buf.writeInt(packet.mirageData.size());
                for (MirageData data : packet.mirageData) {
                    buf.m_130064_(data.pos);
                    buf.writeInt(Block.m_49956_((BlockState)data.blockState));
                    buf.writeInt(data.amplifier);
                    buf.writeBoolean(data.shouldRemove);
                    buf.writeBoolean(data.isPhantomStructure);
                    buf.m_130070_(data.structureName);
                    buf.writeBoolean(data.shouldFade);
                }
            }
            catch (Exception e) {
                System.err.println("Error encoding MirageDataPacket: " + e.getMessage());
            }
        }

        public static MirageDataPacket decode(FriendlyByteBuf buf) {
            try {
                int size = buf.readInt();
                ArrayList<MirageData> mirageData = new ArrayList<MirageData>();
                for (int i = 0; i < size; ++i) {
                    BlockPos pos = buf.m_130135_();
                    BlockState blockState = Block.m_49803_((int)buf.readInt());
                    int amplifier = buf.readInt();
                    boolean shouldRemove = buf.readBoolean();
                    boolean isPhantomStructure = buf.readBoolean();
                    String structureName = buf.m_130277_();
                    boolean shouldFade = buf.readBoolean();
                    mirageData.add(new MirageData(pos, blockState, amplifier, shouldRemove, isPhantomStructure, structureName, shouldFade));
                }
                return new MirageDataPacket(mirageData);
            }
            catch (Exception e) {
                System.err.println("Error decoding MirageDataPacket: " + e.getMessage());
                return new MirageDataPacket(new ArrayList<MirageData>());
            }
        }

        public static void handle(MirageDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
            try {
                ctx.get().enqueueWork(() -> {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                        try {
                            ClientMirageHandler.handleMirageData(packet.mirageData);
                        }
                        catch (Exception e) {
                            System.err.println("Error handling mirage data on client: " + e.getMessage());
                        }
                    }
                });
                ctx.get().setPacketHandled(true);
            }
            catch (Exception e) {
                System.err.println("Error handling MirageDataPacket: " + e.getMessage());
            }
        }
    }

    public static class MirageData {
        public final BlockPos pos;
        public final BlockState blockState;
        public final int amplifier;
        public final boolean shouldRemove;
        public final boolean isPhantomStructure;
        public final String structureName;
        public final boolean shouldFade;

        public MirageData(BlockPos pos, BlockState blockState, int amplifier, boolean shouldRemove) {
            this(pos, blockState, amplifier, shouldRemove, false, "", false);
        }

        public MirageData(BlockPos pos, BlockState blockState, int amplifier, boolean shouldRemove, boolean isPhantomStructure, String structureName) {
            this(pos, blockState, amplifier, shouldRemove, isPhantomStructure, structureName, false);
        }

        public MirageData(BlockPos pos, BlockState blockState, int amplifier, boolean shouldRemove, boolean isPhantomStructure, String structureName, boolean shouldFade) {
            this.pos = pos;
            this.blockState = blockState;
            this.amplifier = amplifier;
            this.shouldRemove = shouldRemove;
            this.isPhantomStructure = isPhantomStructure;
            this.structureName = structureName != null ? structureName : "";
            this.shouldFade = shouldFade;
        }
    }
}

