/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.effects;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RevengeOfThothEffect
extends MobEffect {
    public RevengeOfThothEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.f_36078_ > 0 || player.f_36080_ > 0.0f) {
                int currentLevel = player.f_36078_--;
                int xpNeededForCurrentLevel = this.getXpNeededForLevel(currentLevel);
                float baseDrainRate = Math.max(1.0f, (float)currentLevel * 0.1f);
                float progressToDrain = baseDrainRate / (float)xpNeededForCurrentLevel;
                int originalLevel = currentLevel;
                player.f_36080_ -= progressToDrain;
                if (player.f_36080_ < 0.0f && currentLevel > 0) {
                    if (player.f_36078_ > 0) {
                        int xpNeededForPreviousLevel = this.getXpNeededForLevel(player.f_36078_);
                        player.f_36080_ = 1.0f + player.f_36080_ * (float)xpNeededForCurrentLevel / (float)xpNeededForPreviousLevel;
                    } else {
                        player.f_36080_ = 0.0f;
                    }
                }
                if (player.f_36080_ < 0.0f) {
                    player.f_36080_ = 0.0f;
                }
                boolean lostLevel = player.f_36078_ < originalLevel;
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (lostLevel) {
                        DamageSource smoothBrainDamage = new DamageSource((Holder)player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("afterlifeentombed", "smooth_brain"))));
                        float damage = 1.0f + (float)amplifier;
                        player.m_6469_(smoothBrainDamage, damage);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 20, 0.8, 0.8, 0.8, 0.2);
                        serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11850_, SoundSource.HOSTILE, 0.8f, 0.7f);
                    } else {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), 3, 0.3, 0.3, 0.3, 0.05);
                        serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.HOSTILE, 0.1f, 1.5f);
                    }
                }
            }
        }
    }

    private int getXpNeededForLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public boolean m_8093_() {
        return false;
    }
}

