/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.events;

import com.dracolich777.afterlifeentombed.init.ModEffects;
import com.dracolich777.afterlifeentombed.init.ModItems;
import com.dracolich777.afterlifeentombed.items.CloakOfKonshu;
import com.dracolich777.afterlifeentombed.items.GodType;
import com.dracolich777.afterlifeentombed.items.WandOfIsis;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="afterlifeentombed", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final Map<GodType, MobEffect> POSITIVE_EFFECTS = new EnumMap<GodType, MobEffect>(GodType.class);
    private static final Map<GodType, MobEffect> REVENGE_EFFECTS = new EnumMap<GodType, MobEffect>(GodType.class);

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        CloakOfKonshu.onPlayerDeath(event);
    }

    public static void init() {
        POSITIVE_EFFECTS.put(GodType.RA, MobEffects.f_19607_);
        POSITIVE_EFFECTS.put(GodType.HORUS, MobEffects.f_19606_);
        POSITIVE_EFFECTS.put(GodType.THOTH, MobEffects.f_19605_);
        POSITIVE_EFFECTS.put(GodType.SHU, MobEffects.f_19591_);
        POSITIVE_EFFECTS.put(GodType.GEB, MobEffects.f_19600_);
        POSITIVE_EFFECTS.put(GodType.ISIS, MobEffects.f_19618_);
        POSITIVE_EFFECTS.put(GodType.SETH, MobEffects.f_19611_);
        POSITIVE_EFFECTS.put(GodType.ANUBIS, MobEffects.f_19617_);
        REVENGE_EFFECTS.put(GodType.HORUS, (MobEffect)ModEffects.REVENGE_OF_HORUS.get());
        REVENGE_EFFECTS.put(GodType.RA, (MobEffect)ModEffects.HOLY_FIRE.get());
        REVENGE_EFFECTS.put(GodType.THOTH, (MobEffect)ModEffects.REVENGE_OF_THOTH.get());
        REVENGE_EFFECTS.put(GodType.SHU, (MobEffect)ModEffects.REVENGE_OF_SHU.get());
        REVENGE_EFFECTS.put(GodType.GEB, (MobEffect)ModEffects.REVENGE_OF_GEB.get());
        REVENGE_EFFECTS.put(GodType.ISIS, (MobEffect)ModEffects.REVENGE_OF_ISIS.get());
        REVENGE_EFFECTS.put(GodType.SETH, (MobEffect)ModEffects.REVENGE_OF_SETH.get());
        REVENGE_EFFECTS.put(GodType.ANUBIS, (MobEffect)ModEffects.REVENGE_OF_ANUBIS.get());
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Player player;
        block6: {
            block5: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (!event.getLevel().m_5776_()) break block6;
            }
            return;
        }
        boolean hasWand = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WAND_OF_ISIS.get(), (LivingEntity)player).isPresent();
        if (!hasWand) {
            return;
        }
        ItemStack wandStack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WAND_OF_ISIS.get(), (LivingEntity)player).get()).getRight();
        Block assignedBlock = WandOfIsis.getAssignedBlock(wandStack);
        if (assignedBlock == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = (Level)event.getLevel();
        BlockState newState = assignedBlock.m_49966_();
        event.getLevel().m_7731_(pos, newState, 3);
        level.m_5594_(null, pos, newState.m_60827_().m_56777_(), SoundSource.BLOCKS, (newState.m_60827_().m_56773_() + 1.0f) / 2.0f, newState.m_60827_().m_56774_() * 0.8f);
    }

    @SubscribeEvent
    public static void onLivingDamageCollar(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            LivingEntity target;
            Player player = (Player)entity;
            boolean hasCollar = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.COLLAR_OF_ANUBIS.get(), (LivingEntity)player).isPresent();
            if (hasCollar && (target = event.getEntity()) != player && !target.m_9236_().f_46443_) {
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.JUDGED_UNWORTHY.get(), 1, 0, false, true, true));
                target.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.5f, 2.0f);
            }
        }
    }
}

