/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.events;

import com.dracolich777.afterlifeentombed.init.ModDamageTypes;
import com.dracolich777.afterlifeentombed.init.ModEffects;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RevengeOfHorusEventHandler {
    private static final UUID ARMOR_TOUGHNESS_NULLIFIER_UUID = UUID.fromString("a1b2c3d4-5678-90ab-cdef-123456789abc");
    private static final UUID KNOCKBACK_RESISTANCE_NULLIFIER_UUID = UUID.fromString("fedcba98-7654-3210-fedc-ba9876543210");
    private static final UUID ARMOR_NULLIFIER_UUID = UUID.fromString("12345678-9abc-def0-1234-56789abcdef0");

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_() && entity.m_21023_((MobEffect)ModEffects.REVENGE_OF_HORUS.get())) {
            DamageSource originalSource = event.getSource();
            if (originalSource.m_276093_(ModDamageTypes.HORUS_DAMAGE)) {
                return;
            }
            float originalDamage = event.getAmount();
            event.setCanceled(true);
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DamageSource horusDamageSource = ModDamageTypes.createHorusDamage(serverLevel);
                int oldInvulnerableTime = entity.f_19802_;
                entity.f_19802_ = 0;
                entity.m_6469_(horusDamageSource, originalDamage);
                entity.f_19802_ = oldInvulnerableTime;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && entity.m_21023_((MobEffect)ModEffects.REVENGE_OF_HORUS.get())) {
            RevengeOfHorusEventHandler.forceNullifyArmorStats(entity);
        }
    }

    @SubscribeEvent
    public static void onPotionAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() == ModEffects.REVENGE_OF_HORUS.get()) {
            LivingEntity entity = event.getEntity();
            RevengeOfHorusEventHandler.nullifyArmorStats(entity);
        }
    }

    @SubscribeEvent
    public static void onPotionRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() == ModEffects.REVENGE_OF_HORUS.get()) {
            LivingEntity entity = event.getEntity();
            RevengeOfHorusEventHandler.restoreArmorStats(entity);
        }
    }

    @SubscribeEvent
    public static void onPotionExpired(MobEffectEvent.Expired event) {
        if (event.getEffectInstance().m_19544_() == ModEffects.REVENGE_OF_HORUS.get()) {
            LivingEntity entity = event.getEntity();
            RevengeOfHorusEventHandler.restoreArmorStats(entity);
        }
    }

    private static void nullifyArmorStats(LivingEntity entity) {
        double currentArmor = entity.m_21133_(Attributes.f_22284_);
        double currentArmorToughness = entity.m_21133_(Attributes.f_22285_);
        double currentKnockbackRes = entity.m_21133_(Attributes.f_22278_);
        AttributeModifier armorNullifier = new AttributeModifier(ARMOR_NULLIFIER_UUID, "horus_armor_nullifier", -currentArmor, AttributeModifier.Operation.ADDITION);
        AttributeModifier armorToughnessNullifier = new AttributeModifier(ARMOR_TOUGHNESS_NULLIFIER_UUID, "horus_armor_toughness_nullifier", -currentArmorToughness, AttributeModifier.Operation.ADDITION);
        AttributeModifier knockbackResNullifier = new AttributeModifier(KNOCKBACK_RESISTANCE_NULLIFIER_UUID, "horus_knockback_resistance_nullifier", -currentKnockbackRes, AttributeModifier.Operation.ADDITION);
        if (!entity.m_21051_(Attributes.f_22284_).m_22109_(armorNullifier)) {
            entity.m_21051_(Attributes.f_22284_).m_22118_(armorNullifier);
        }
        if (!entity.m_21051_(Attributes.f_22285_).m_22109_(armorToughnessNullifier)) {
            entity.m_21051_(Attributes.f_22285_).m_22118_(armorToughnessNullifier);
        }
        if (!entity.m_21051_(Attributes.f_22278_).m_22109_(knockbackResNullifier)) {
            entity.m_21051_(Attributes.f_22278_).m_22118_(knockbackResNullifier);
        }
    }

    private static void forceNullifyArmorStats(LivingEntity entity) {
        double currentArmor = entity.m_21133_(Attributes.f_22284_);
        double currentArmorToughness = entity.m_21133_(Attributes.f_22285_);
        double currentKnockbackRes = entity.m_21133_(Attributes.f_22278_);
        if (currentArmor > 0.0) {
            entity.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_NULLIFIER_UUID);
            AttributeModifier armorNullifier = new AttributeModifier(ARMOR_NULLIFIER_UUID, "horus_armor_nullifier", -currentArmor, AttributeModifier.Operation.ADDITION);
            entity.m_21051_(Attributes.f_22284_).m_22118_(armorNullifier);
        }
        if (currentArmorToughness > 0.0) {
            entity.m_21051_(Attributes.f_22285_).m_22120_(ARMOR_TOUGHNESS_NULLIFIER_UUID);
            AttributeModifier armorToughnessNullifier = new AttributeModifier(ARMOR_TOUGHNESS_NULLIFIER_UUID, "horus_armor_toughness_nullifier", -currentArmorToughness, AttributeModifier.Operation.ADDITION);
            entity.m_21051_(Attributes.f_22285_).m_22118_(armorToughnessNullifier);
        }
        if (currentKnockbackRes > 0.0) {
            entity.m_21051_(Attributes.f_22278_).m_22120_(KNOCKBACK_RESISTANCE_NULLIFIER_UUID);
            AttributeModifier knockbackResNullifier = new AttributeModifier(KNOCKBACK_RESISTANCE_NULLIFIER_UUID, "horus_knockback_resistance_nullifier", -currentKnockbackRes, AttributeModifier.Operation.ADDITION);
            entity.m_21051_(Attributes.f_22278_).m_22118_(knockbackResNullifier);
        }
    }

    private static void restoreArmorStats(LivingEntity entity) {
        entity.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_NULLIFIER_UUID);
        entity.m_21051_(Attributes.f_22285_).m_22120_(ARMOR_TOUGHNESS_NULLIFIER_UUID);
        entity.m_21051_(Attributes.f_22278_).m_22120_(KNOCKBACK_RESISTANCE_NULLIFIER_UUID);
    }
}

