/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.events;

import com.dracolich777.afterlifeentombed.capabilities.GodAvatarCapability;
import com.dracolich777.afterlifeentombed.items.GodType;
import com.dracolich777.afterlifeentombed.items.GodstoneItem;
import com.dracolich777.afterlifeentombed.network.GodAvatarPackets;
import com.dracolich777.afterlifeentombed.network.SyncGodAvatarPacket;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="afterlifeentombed", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SethAvatarAbilities {
    public static final int ABILITY_ONE_WITH_CHAOS = 1;
    public static final int ABILITY_DAMAGE_NEGATION = 2;
    public static final int ABILITY_DESERT_WALKER = 3;
    public static final int ABILITY_CHAOS_INCARNATE = 4;
    private static final UUID CHAOS_INCARNATE_SIZE_UUID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    private static final UUID CHAOS_INCARNATE_SPEED_UUID = UUID.fromString("b2c3d4e5-f6a7-8901-bcde-f12345678901");

    private static boolean hasAgentOfGodsOrigin(Player player) {
        return player.getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).isPresent();
    }

    private static boolean isSethAvatar(Player player) {
        return player.getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).map(cap -> cap.getSelectedGod() == GodType.SETH).orElse(false);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        if (event.getSource().m_7639_() instanceof Player && SethAvatarAbilities.isSethAvatar(player = (Player)event.getSource().m_7639_()) && event.getEntity() instanceof LivingEntity) {
            Vec3 toPlayer;
            LivingEntity target = event.getEntity();
            Vec3 playerPos = player.m_20182_();
            Vec3 targetPos = target.m_20182_();
            Vec3 targetLook = target.m_20154_();
            double dot = targetLook.m_82526_(toPlayer = playerPos.m_82546_(targetPos).m_82541_());
            if (dot > 0.5) {
                event.setAmount(event.getAmount() * 3.0f);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a76Trickster God: Backstab!"));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (!SethAvatarAbilities.isSethAvatar(player)) {
            return;
        }
        player.getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).ifPresent(cap -> {
            long activationTime;
            long currentTime = player.m_9236_().m_46467_();
            if (!player.m_21023_(MobEffects.f_19611_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, false, false));
            }
            if (cap.isOneWithChaosActive()) {
                int timeUsed = cap.getOneWithChaosTimeUsed();
                cap.setOneWithChaosTimeUsed(++timeUsed);
                if (timeUsed >= 2400 && player instanceof ServerPlayer) {
                    SethAvatarAbilities.deactivateOneWithChaos((ServerPlayer)player, cap);
                }
            }
            if (cap.isDamageNegationActive() && (activationTime = currentTime - cap.getDamageNegationCooldown()) >= 200L) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7cDamage storage ready! Attack to release!"));
            }
            if (cap.isChaosIncarnateActive()) {
                long activationTime2 = currentTime - cap.getChaosIncarnateCooldown();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 20, 9, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, 4, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 20, 4, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 20, 4, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 254, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 20, 254, false, false));
                if (!player.m_150110_().f_35936_) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                }
                if (activationTime2 >= 1200L && player instanceof ServerPlayer) {
                    SethAvatarAbilities.deactivateChaosIncarnate((ServerPlayer)player, cap, currentTime);
                }
            }
            if (cap.isDesertWalkerFlying() && player.m_20096_()) {
                cap.setDesertWalkerFlying(false);
                cap.setDesertWalkerCooldown(currentTime + 1200L);
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7eDesert Walker flight ended"));
            }
        });
    }

    @SubscribeEvent
    public static void onPotionApplicable(MobEffectEvent.Applicable event) {
        MobEffect effect;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SethAvatarAbilities.isSethAvatar(player = (Player)livingEntity) && !(effect = event.getEffectInstance().m_19544_()).m_19486_()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        String damageType;
        Player player;
        if (event.getEntity() instanceof Player && SethAvatarAbilities.isSethAvatar(player = (Player)event.getEntity()) && ((damageType = event.getSource().m_19385_()).contains("fire") || damageType.contains("lava") || damageType.contains("hot") || damageType.contains("flame"))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGoldDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack weapon;
        Entity entity;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SethAvatarAbilities.isSethAvatar(player = (Player)livingEntity) && (entity = event.getSource().m_7640_()) instanceof LivingEntity && ((weapon = (attacker = (LivingEntity)entity).m_21205_()).m_150930_(Items.f_42430_) || weapon.m_150930_(Items.f_42433_))) {
            event.setAmount(event.getAmount() * 2.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickGoldBlocks(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (!SethAvatarAbilities.isSethAvatar(player)) {
            return;
        }
        BlockPos belowPos = player.m_20183_().m_7495_();
        if (player.m_9236_().m_8055_(belowPos).m_60713_(Blocks.f_50074_)) {
            player.m_6469_(player.m_269291_().m_269425_(), 2.0f);
        }
    }

    public static void activateAbility(ServerPlayer player, int abilityId) {
        if (!SethAvatarAbilities.isSethAvatar((Player)player)) {
            return;
        }
        player.getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).ifPresent(cap -> {
            long currentTime = player.m_9236_().m_46467_();
            switch (abilityId) {
                case 1: {
                    SethAvatarAbilities.toggleOneWithChaos(player, cap, currentTime);
                    break;
                }
                case 2: {
                    SethAvatarAbilities.toggleDamageNegation(player, cap, currentTime);
                    break;
                }
                case 3: {
                    SethAvatarAbilities.activateDesertWalker(player, cap, currentTime);
                    break;
                }
                case 4: {
                    SethAvatarAbilities.activateChaosIncarnate(player, cap, currentTime);
                }
            }
        });
    }

    private static void toggleOneWithChaos(ServerPlayer player, GodAvatarCapability.IGodAvatar cap, long currentTime) {
        boolean unlimited = cap.isChaosIncarnateActive();
        if (cap.isOneWithChaosActive()) {
            SethAvatarAbilities.deactivateOneWithChaos(player, cap);
        } else {
            if (!unlimited && currentTime < cap.getOneWithChaosCooldown()) {
                long remaining = (cap.getOneWithChaosCooldown() - currentTime) / 20L;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7cOne with Chaos on cooldown: " + remaining + "s")));
                return;
            }
            if (!unlimited && cap.getOneWithChaosTimeUsed() >= 2400) {
                if (!unlimited) {
                    cap.setOneWithChaosCooldown(currentTime + (long)cap.getOneWithChaosTimeUsed());
                }
                cap.setOneWithChaosTimeUsed(0);
            }
            cap.setOneWithChaosActive(true);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, Integer.MAX_VALUE, 0, false, false));
            player.m_20242_(true);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a75One with Chaos activated!"));
        }
    }

    private static void deactivateOneWithChaos(ServerPlayer player, GodAvatarCapability.IGodAvatar cap) {
        cap.setOneWithChaosActive(false);
        player.m_21195_(MobEffects.f_19609_);
        player.m_20242_(false);
        if (!cap.isChaosIncarnateActive()) {
            long currentTime = player.m_9236_().m_46467_();
            cap.setOneWithChaosCooldown(currentTime + (long)cap.getOneWithChaosTimeUsed());
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a75One with Chaos deactivated"));
    }

    private static void toggleDamageNegation(ServerPlayer player, GodAvatarCapability.IGodAvatar cap, long currentTime) {
        boolean unlimited = cap.isChaosIncarnateActive();
        if (cap.isDamageNegationActive()) {
            return;
        }
        if (!unlimited && currentTime < cap.getDamageNegationCooldown()) {
            long remaining = (cap.getDamageNegationCooldown() - currentTime) / 20L;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7cDamage Negation on cooldown: " + remaining + "s")));
            return;
        }
        cap.setDamageNegationActive(true);
        cap.setStoredDamage(0.0f);
        player.m_213846_((Component)Component.m_237113_((String)"\u00a74Damage Negation active - storing damage for 10s"));
    }

    @SubscribeEvent
    public static void onDamageNegation(LivingDamageEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SethAvatarAbilities.isSethAvatar(player = (Player)livingEntity)) {
            player.getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).ifPresent(cap -> {
                long currentTime;
                long activationTime;
                if (cap.isDamageNegationActive() && (activationTime = (currentTime = player.m_9236_().m_46467_()) - cap.getDamageNegationCooldown()) < 200L) {
                    float stored = cap.getStoredDamage();
                    cap.setStoredDamage(stored + event.getAmount());
                    event.setAmount(0.0f);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a74Stored: " + cap.getStoredDamage() + " damage")));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent event) {
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && SethAvatarAbilities.isSethAvatar(player = (Player)entity)) {
            player.getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).ifPresent(cap -> {
                long currentTime;
                long activationTime;
                if (cap.isDamageNegationActive() && cap.getStoredDamage() > 0.0f && (activationTime = (currentTime = player.m_9236_().m_46467_()) - cap.getDamageNegationCooldown()) >= 200L) {
                    event.setAmount(event.getAmount() + cap.getStoredDamage());
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a74Released " + cap.getStoredDamage() + " stored damage!")));
                    cap.setStoredDamage(0.0f);
                    cap.setDamageNegationActive(false);
                    if (!cap.isChaosIncarnateActive()) {
                        cap.setDamageNegationCooldown(currentTime + 1200L);
                    }
                }
            });
        }
    }

    private static void activateDesertWalker(ServerPlayer player, GodAvatarCapability.IGodAvatar cap, long currentTime) {
        boolean unlimited = cap.isChaosIncarnateActive();
        if (!unlimited && currentTime < cap.getDesertWalkerCooldown()) {
            long remaining = (cap.getDesertWalkerCooldown() - currentTime) / 20L;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7cDesert Walker on cooldown: " + remaining + "s")));
            return;
        }
        if (player.m_6060_()) {
            cap.setDesertWalkerFlying(true);
            player.m_150110_().f_35936_ = true;
            player.m_150110_().f_35935_ = true;
            player.m_6885_();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7eDesert Walker: Flight activated!"));
        } else {
            Vec3 start = player.m_146892_();
            Vec3 end = start.m_82549_(player.m_20154_().m_82490_(30.0));
            BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            if (result.m_6662_() != HitResult.Type.MISS) {
                Vec3 teleportPos = result.m_82450_();
                player.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7eDesert Walker: Teleported!"));
                if (!unlimited) {
                    cap.setDesertWalkerCooldown(currentTime + 1200L);
                }
            }
        }
    }

    private static void activateChaosIncarnate(ServerPlayer player, GodAvatarCapability.IGodAvatar cap, long currentTime) {
        GodstoneItem godstone;
        GodType newGod;
        if (currentTime < cap.getChaosIncarnateCooldown()) {
            long remaining = (cap.getChaosIncarnateCooldown() - currentTime) / 20L;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7cChaos Incarnate on cooldown: " + remaining + "s")));
            return;
        }
        ItemStack mainHand = player.m_21205_();
        Item item = mainHand.m_41720_();
        if (item instanceof GodstoneItem && (newGod = (godstone = (GodstoneItem)item).getGodType()) != GodType.SETH && newGod != GodType.NONE) {
            cap.setSelectedGod(newGod);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a76You are now the avatar of " + newGod.name() + "!")));
            GodAvatarPackets.INSTANCE.sendToServer((Object)new SyncGodAvatarPacket(newGod));
            return;
        }
        cap.setChaosIncarnateActive(true);
        cap.setChaosIncarnateCooldown(currentTime);
        player.m_213846_((Component)Component.m_237113_((String)"\u00a75\u00a7lCHAOS INCARNATE ACTIVATED!"));
    }

    private static void deactivateChaosIncarnate(ServerPlayer player, GodAvatarCapability.IGodAvatar cap, long currentTime) {
        cap.setChaosIncarnateActive(false);
        cap.setChaosIncarnateCooldown(currentTime + 6000L);
        if (!cap.isDesertWalkerFlying()) {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
            player.m_6885_();
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 1200, 0, false, true));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a75Chaos Incarnate ended"));
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("afterlifeentombed", "god_avatar"), (ICapabilityProvider)new GodAvatarCapability.GodAvatarProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).ifPresent(oldCap -> event.getEntity().getCapability(GodAvatarCapability.GOD_AVATAR_CAPABILITY).ifPresent(newCap -> newCap.setSelectedGod(oldCap.getSelectedGod())));
        }
    }
}

