/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CloakOfKonshu
extends Item
implements ICurioItem {
    private static final Map<UUID, Double> lastZ = new HashMap<UUID, Double>();
    private static final Map<UUID, Double> lastX = new HashMap<UUID, Double>();

    public CloakOfKonshu(Item.Properties properties) {
        super(properties);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return slotContext.identifier().equals("back");
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return slotContext.identifier().equals("back");
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        LivingEntity entity = slotContext.entity();
        if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
            // empty if block
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        double lookZ;
        Player player;
        block11: {
            block10: {
                LivingEntity entity = slotContext.entity();
                if (!(entity instanceof Player)) break block10;
                player = (Player)entity;
                if (!entity.m_9236_().f_46443_) break block11;
            }
            return;
        }
        UUID uuid = player.m_20148_();
        double prevX = lastX.getOrDefault(uuid, player.m_20185_());
        double prevZ = lastZ.getOrDefault(uuid, player.m_20189_());
        double dx = player.m_20185_() - prevX;
        double dz = player.m_20189_() - prevZ;
        double forward = 0.0;
        double backward = 0.0;
        double lookX = -Math.sin(Math.toRadians(player.m_146908_()));
        double dot = dx * lookX + dz * (lookZ = Math.cos(Math.toRadians(player.m_146908_())));
        if (dot > 0.08) {
            forward = dot;
        } else if (dot < -0.08) {
            backward = -dot;
        }
        if (player.m_20096_() && !player.m_6047_()) {
            if (forward > 0.0) {
                this.addDaylightTime(player.m_9236_(), 2);
            } else if (backward > 0.0) {
                this.addDaylightTime(player.m_9236_(), -2);
            }
        }
        lastX.put(uuid, player.m_20185_());
        lastZ.put(uuid, player.m_20189_());
    }

    private void addDaylightTime(Level level, int ticks) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        long dayTime = serverLevel.m_46468_();
        long newTime = Math.max(0L, dayTime + (long)ticks + 10L);
        serverLevel.m_8615_(newTime);
    }

    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        CuriosApi.getCuriosHelper().findEquippedCurio((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("afterlifeentombed:cloak_of_konshu")), (LivingEntity)player).ifPresent(slot -> player.m_150109_().m_36054_(((ItemStack)slot.getRight()).m_41777_()));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"A mystical cloak that binds to your soul.").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237113_((String)"Cannot be removed once equipped, even by death.").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237113_((String)"Wearing it lets you bend the day: step forward to speed up, back to slow down.").m_130940_(ChatFormatting.AQUA));
    }
}

