/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import com.dracolich777.afterlibs.api.AfterLibsAPI;
import com.dracolich777.afterlifeentombed.AfterlifeEntombedMod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CrownOfSeth
extends Item
implements ICurioItem {
    public CrownOfSeth(Item.Properties properties) {
        super(properties);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            CompoundTag entityData = entity.getPersistentData();
            if (entityData.m_128471_("crown_invisibility_pending")) {
                long equipTime = entityData.m_128454_("crown_equip_time");
                long currentTime = level.m_46467_();
                if (currentTime - equipTime >= 60L) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, Integer.MAX_VALUE, 0, false, false, true));
                    entityData.m_128379_("crown_invisibility_pending", false);
                    AfterlifeEntombedMod.LOGGER.info("Crown invisibility applied after dissolve delay for: {}", (Object)entity);
                }
            }
            if (level.m_46467_() % 20L == 0L) {
                if (!entityData.m_128471_("crown_invisibility_pending") && !entity.m_21023_(MobEffects.f_19609_)) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, Integer.MAX_VALUE, 0, false, false, true));
                }
                if (!entity.m_21023_(MobEffects.f_19594_)) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19594_, 80, 0, false, false, true));
                }
            }
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.m_9236_();
        AfterlifeEntombedMod.LOGGER.info("CrownOfSeth onEquip called! Entity: {}, ClientSide: {}", (Object)entity, (Object)level.m_5776_());
        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12554_, SoundSource.PLAYERS, 0.5f, 1.5f);
        if (!level.m_5776_()) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19594_, 80, 0, false, false, true));
        }
        if (!level.m_5776_() && entity instanceof Player) {
            AfterlifeEntombedMod.LOGGER.info("SERVER: Crown equipped, spawning seth_crown_disolve particle");
            double headY = entity.m_20186_() + (double)entity.m_20206_() * 0.8;
            AfterLibsAPI.spawnAfterlifeParticle(level, "seth_crown_disolve", entity.m_20185_(), headY, entity.m_20189_(), 1.0f);
        }
        if (level.m_5776_()) {
            AfterlifeEntombedMod.LOGGER.info("CLIENT: Crown equipped, particle effects removed as per consolidation to AfterLibs");
        }
        if (!level.m_5776_()) {
            CompoundTag entityData = entity.getPersistentData();
            entityData.m_128356_("crown_equip_time", level.m_46467_());
            entityData.m_128379_("crown_invisibility_pending", true);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.m_9236_();
        AfterlifeEntombedMod.LOGGER.info("CrownOfSeth onUnequip called! Entity: {}, ClientSide: {}", (Object)entity, (Object)level.m_5776_());
        if (!level.m_5776_() && entity instanceof Player) {
            AfterlifeEntombedMod.LOGGER.info("SERVER: Crown unequipped, spawning seth_crown_appear particle");
            double headY = entity.m_20186_() + (double)entity.m_20206_() * 0.8;
            AfterLibsAPI.spawnAfterlifeParticle(level, "seth_crown_appear", entity.m_20185_(), headY, entity.m_20189_(), 1.0f);
        }
        if (level.m_5776_()) {
            AfterlifeEntombedMod.LOGGER.info("CLIENT: Crown unequipped, particle effects removed as per consolidation to AfterLibs");
        }
        if (!level.m_5776_()) {
            CompoundTag entityData = entity.getPersistentData();
            entityData.m_128473_("crown_equip_time");
            entityData.m_128473_("crown_invisibility_pending");
        }
        entity.m_21195_(MobEffects.f_19594_);
        entity.m_21195_(MobEffects.f_19609_);
        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 2.0f);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        CompoundTag tag;
        if (!level.f_46443_ && entity instanceof Player && !(tag = stack.m_41784_()).m_128471_("CrownPickedUp")) {
            tag.m_128379_("CrownPickedUp", true);
            stack.m_41751_(tag);
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.crown_of_seth.tooltip").m_130940_(ChatFormatting.RED));
        boolean pickedUp = stack.m_41784_().m_128471_("CrownPickedUp");
        if (pickedUp) {
            tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.crown_of_seth.tooltip.invis").m_130940_(ChatFormatting.DARK_PURPLE));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.crown_of_seth.tooltip.invis").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.OBFUSCATED}));
        }
    }
}

