/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import com.dracolich777.afterlifeentombed.init.ModEffects;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GebsMight
extends SwordItem {
    private static final String COOLDOWN_KEY = "geb_might_cooldown";
    private static final int COOLDOWN_TICKS = 100;
    private static final double SHOCKWAVE_RADIUS = 8.0;
    private static final double KNOCKBACK_STRENGTH = 2.0;

    public GebsMight(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, 14, -2.4f, properties);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.REVENGE_OF_GEB.get(), 20, 0));
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(COOLDOWN_KEY)) {
            long lastUse = itemStack.m_41783_().m_128454_(COOLDOWN_KEY);
            long currentTime = level.m_46467_();
            if (currentTime - lastUse < 100L) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
        }
        if (!level.f_46443_) {
            this.performEarthShockwave(level, player);
            if (itemStack.m_41783_() == null) {
                itemStack.m_41784_();
            }
            itemStack.m_41783_().m_128356_(COOLDOWN_KEY, level.m_46467_());
            player.m_36335_().m_41524_((Item)this, 100);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private void performEarthShockwave(Level level, Player player) {
        Vec3 playerPos = player.m_20182_();
        BlockPos centerPos = player.m_20183_();
        level.m_5594_(null, centerPos, SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.5f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int wave = 0; wave < 3; ++wave) {
                double waveRadius = (double)(wave + 1) * 3.0;
                for (double angle = 0.0; angle < Math.PI * 2; angle += 0.1) {
                    for (double r = Math.max(1.0, waveRadius - 1.0); r <= waveRadius; r += 0.5) {
                        double x = playerPos.f_82479_ + r * Math.cos(angle);
                        double z = playerPos.f_82481_ + r * Math.sin(angle);
                        BlockPos particlePos = new BlockPos((int)x, centerPos.m_123342_() - 1, (int)z);
                        BlockState blockState = level.m_8055_(particlePos);
                        if (blockState.m_60795_()) continue;
                        double particleDelay = (double)wave * 0.1 + r / waveRadius * 0.2;
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, (double)centerPos.m_123342_() + 0.1 + (double)wave * 0.2, z, 3, 0.2, 0.3 + particleDelay, 0.2, 0.1);
                    }
                }
            }
        }
        AABB searchArea = new AABB(playerPos.m_82492_(8.0, 3.0, 8.0), playerPos.m_82520_(8.0, 3.0, 8.0));
        List nearbyEntities = level.m_45976_(LivingEntity.class, searchArea);
        for (LivingEntity entity : nearbyEntities) {
            Vec3 entityPos;
            double distance;
            if (entity == player || !((distance = (entityPos = entity.m_20182_()).m_82554_(playerPos)) <= 8.0) || !(distance > 0.0)) continue;
            Vec3 knockbackDir = entityPos.m_82546_(playerPos).m_82541_();
            double knockbackForce = 2.0 * (3.0 - distance / 8.0);
            Vec3 knockbackVelocity = knockbackDir.m_82490_(knockbackForce);
            knockbackVelocity = knockbackVelocity.m_82520_(0.0, 0.3, 0.0);
            entity.m_20256_(entity.m_20184_().m_82549_(knockbackVelocity));
            entity.f_19864_ = true;
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.gebs_might.tooltip1").m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.gebs_might.tooltip2").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.gebs_might.tooltip3").m_130940_(ChatFormatting.DARK_GRAY));
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(COOLDOWN_KEY) && level != null) {
            long lastUse = stack.m_41783_().m_128454_(COOLDOWN_KEY);
            long currentTime = level.m_46467_();
            long remainingCooldown = 100L - (currentTime - lastUse);
            if (remainingCooldown > 0L) {
                float seconds = (float)remainingCooldown / 20.0f;
                tooltip.add((Component)Component.m_237113_((String)String.format("Cooldown: %.1fs", Float.valueOf(seconds))).m_130940_(ChatFormatting.RED));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"Earth Shockwave Ready").m_130940_(ChatFormatting.GREEN));
            }
        }
    }
}

