/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PricklyPearArmor
extends ArmorItem {
    public PricklyPearArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.thorns_effect").m_130940_(ChatFormatting.DARK_GREEN));
        if (PricklyPearArmor.hasStoredEffect(stack)) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                String effectId = nbt.m_128461_("StoredEffect");
                int duration = nbt.m_128451_("EffectDuration");
                int amplifier = nbt.m_128451_("EffectAmplifier");
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectId));
                if (effect != null) {
                    String effectName = effect.m_19482_().getString();
                    int durationSeconds = duration / 20;
                    int minutes = durationSeconds / 60;
                    int seconds = durationSeconds % 60;
                    String amplifierText = amplifier > 0 ? " " + (amplifier + 1) : "";
                    String durationText = String.format("%d:%02d", minutes, seconds);
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.afterlifeentombed.stored_effect", (Object[])new Object[]{effectName + amplifierText, durationText}).m_130940_(ChatFormatting.LIGHT_PURPLE));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.afterlifeentombed.no_effect").m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        LivingEntity lastHurtBy;
        if (!level.f_46443_ && player.f_20916_ > 0 && (lastHurtBy = player.m_21188_()) != null) {
            this.applyStoredEffect(stack, lastHurtBy);
            lastHurtBy.m_6469_(level.m_269111_().m_269374_((Entity)player), 2.0f);
        }
    }

    private void applyStoredEffect(ItemStack stack, LivingEntity target) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("StoredEffect")) {
            String effectId = nbt.m_128461_("StoredEffect");
            int duration = nbt.m_128451_("EffectDuration");
            int amplifier = nbt.m_128451_("EffectAmplifier");
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectId));
            if (effect != null) {
                target.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            }
        }
    }

    public static void storeEffect(ItemStack stack, MobEffect effect, int duration, int amplifier) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("StoredEffect", BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString());
        nbt.m_128405_("EffectDuration", duration);
        nbt.m_128405_("EffectAmplifier", amplifier);
    }

    public static boolean hasStoredEffect(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("StoredEffect");
    }

    public static String getStoredEffectName(ItemStack stack) {
        String effectId;
        MobEffect effect;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("StoredEffect") && (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectId = nbt.m_128461_("StoredEffect")))) != null) {
            return effect.m_19482_().getString();
        }
        return "";
    }
}

