/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class WandOfIsis
extends Item
implements ICurioItem {
    public static final String ASSIGNED_BLOCK_NBT_KEY = "AssignedBlock";
    private static final String INITIALIZED_NBT_KEY = "Initialized";

    public WandOfIsis(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        Block randomBlock;
        CompoundTag nbt;
        if (!pLevel.f_46443_ && !(nbt = pStack.m_41784_()).m_128471_(INITIALIZED_NBT_KEY) && (randomBlock = this.getRandomSurvivalPlacableBlock(pLevel.m_213780_())) != null) {
            nbt.m_128359_(ASSIGNED_BLOCK_NBT_KEY, ForgeRegistries.BLOCKS.getKey((Object)randomBlock).toString());
            nbt.m_128379_(INITIALIZED_NBT_KEY, true);
            pStack.m_41751_(nbt);
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    private Block getRandomSurvivalPlacableBlock(RandomSource randomSource) {
        List placableBlocks = ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.m_5456_() != Items.f_41852_).filter(this::isNotOperatorOnlyBlock).filter(this::isNormalSurvivalBlock).collect(Collectors.toList());
        if (placableBlocks.isEmpty()) {
            return null;
        }
        return (Block)placableBlocks.get(randomSource.m_188503_(placableBlocks.size()));
    }

    private boolean isNotOperatorOnlyBlock(Block block) {
        return block != Blocks.f_50752_ && block != Blocks.f_50375_ && block != Blocks.f_152480_ && block != Blocks.f_50454_ && block != Blocks.f_50677_ && block != Blocks.f_50678_ && block != Blocks.f_50272_ && block != Blocks.f_50448_ && block != Blocks.f_50447_ && !block.m_7705_().contains("debug") && !block.m_7705_().contains("test");
    }

    private boolean isNormalSurvivalBlock(Block block) {
        return !block.m_49966_().m_247087_() && block != Blocks.f_50257_ && block != Blocks.f_50258_ && block != Blocks.f_50142_ && block != Blocks.f_49990_ && block != Blocks.f_49991_ && block != Blocks.f_50628_ && block != Blocks.f_50627_ && block != Blocks.f_50626_ && !block.m_7705_().contains("_air") && block != Blocks.f_50083_ && block != Blocks.f_50084_ && block != Blocks.f_50110_ && block != Blocks.f_50040_ && !this.isTwoBlockStructure(block);
    }

    private boolean isTwoBlockStructure(Block block) {
        if (block == Blocks.f_50028_ || block == Blocks.f_50029_ || block == Blocks.f_50025_ || block == Blocks.f_50026_ || block == Blocks.f_50023_ || block == Blocks.f_50021_ || block == Blocks.f_50027_ || block == Blocks.f_50017_ || block == Blocks.f_50022_ || block == Blocks.f_50019_ || block == Blocks.f_50068_ || block == Blocks.f_50067_ || block == Blocks.f_50020_ || block == Blocks.f_50024_ || block == Blocks.f_50066_ || block == Blocks.f_50018_) {
            return true;
        }
        if (block == Blocks.f_50721_ || block == Blocks.f_50260_ || block == Blocks.f_50752_) {
            return true;
        }
        if (block == Blocks.f_50487_ || block == Blocks.f_50485_ || block == Blocks.f_50488_ || block == Blocks.f_50486_ || block == Blocks.f_50154_ || block == Blocks.f_50484_ || block == Blocks.f_50671_ || block == Blocks.f_50672_ || block == Blocks.f_50166_) {
            return true;
        }
        if (block == Blocks.f_50359_ || block == Blocks.f_50360_ || block == Blocks.f_50355_ || block == Blocks.f_50356_ || block == Blocks.f_50357_ || block == Blocks.f_50358_ || block == Blocks.f_50038_ || block == Blocks.f_276668_) {
            return true;
        }
        if (block == Blocks.f_50087_ || block == Blocks.f_50325_ || block == Blocks.f_50624_ || block == Blocks.f_50680_ || block == Blocks.f_50569_ || block == Blocks.f_50489_ || block == Blocks.f_152587_) {
            return true;
        }
        String blockName = block.m_7705_().toLowerCase();
        return blockName.contains("_bed") || blockName.contains("_door") || blockName.contains("tall_") || blockName.contains("large_");
    }

    public static Block getAssignedBlock(ItemStack stack) {
        String blockId;
        ResourceLocation rl;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(ASSIGNED_BLOCK_NBT_KEY) && (rl = ResourceLocation.m_135820_((String)(blockId = nbt.m_128461_(ASSIGNED_BLOCK_NBT_KEY)))) != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(rl);
        }
        return null;
    }

    public boolean m_5812_(ItemStack pStack) {
        return WandOfIsis.getAssignedBlock(pStack) != null;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.wand_of_isis.tooltip").m_130940_(ChatFormatting.DARK_PURPLE));
        Block assignedBlock = WandOfIsis.getAssignedBlock(stack);
        if (assignedBlock != null) {
            MutableComponent blockName = assignedBlock.m_49954_().m_6881_().m_130940_(ChatFormatting.RED);
            tooltip.add((Component)Component.m_237113_((String)"Block: ").m_7220_((Component)blockName));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"No block assigned").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

