/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.mobs;

import com.dracolich777.afterlifeentombed.init.ModEntityTypes;
import com.dracolich777.afterlifeentombed.items.ShabtiItem;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShabtiEntity
extends LivingEntity {
    private static final EntityDataAccessor<String> OWNER_UUID = SynchedEntityData.m_135353_(ShabtiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> OWNER_YAW = SynchedEntityData.m_135353_(ShabtiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> OWNER_PITCH = SynchedEntityData.m_135353_(ShabtiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> OWNER_YAW_HEAD = SynchedEntityData.m_135353_(ShabtiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<CompoundTag> OWNER_INVENTORY = SynchedEntityData.m_135353_(ShabtiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Integer> DISPLAY_FLAGS = SynchedEntityData.m_135353_(ShabtiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> OWNER_STATUS_INFO = SynchedEntityData.m_135353_(ShabtiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final int SHOW_ARMOR = 1;
    public static final int SHOW_ITEMS = 2;
    public static final int SHOW_ROTATION = 4;
    public static final int SHOW_HEALTH = 8;
    public static final int SHOW_HUNGER = 16;
    public static final int SHOW_XP = 32;
    public static final int SHOW_COORDS = 64;
    public static final int SHOW_DIMENSION = 128;
    private UUID ownerUUID;
    private ServerPlayer cachedOwner;
    private int displayFlags = 111;

    public ShabtiEntity(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.m_20331_(false);
    }

    public ShabtiEntity(Level level, ServerPlayer owner) {
        this((EntityType<? extends LivingEntity>)((EntityType)ModEntityTypes.SHABTI.get()), level);
        this.ownerUUID = owner.m_20148_();
        this.cachedOwner = owner;
        this.f_19804_.m_135381_(OWNER_UUID, (Object)owner.m_20148_().toString());
        this.updateFromOwner();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, (Object)"");
        this.f_19804_.m_135372_(OWNER_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OWNER_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OWNER_YAW_HEAD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OWNER_INVENTORY, (Object)new CompoundTag());
        this.f_19804_.m_135372_(DISPLAY_FLAGS, (Object)111);
        this.f_19804_.m_135372_(OWNER_STATUS_INFO, (Object)"");
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.updateFromOwner();
        }
    }

    private void updateFromOwner() {
        if (this.cachedOwner == null || !this.cachedOwner.m_6084_()) {
            if (this.ownerUUID != null && this.m_9236_().m_7654_() != null) {
                this.cachedOwner = this.m_9236_().m_7654_().m_6846_().m_11259_(this.ownerUUID);
            }
            if (this.cachedOwner == null) {
                return;
            }
        }
        try {
            ItemStack offHand;
            this.f_19804_.m_135381_(OWNER_YAW, (Object)Float.valueOf(this.cachedOwner.m_146908_()));
            this.f_19804_.m_135381_(OWNER_PITCH, (Object)Float.valueOf(this.cachedOwner.m_146909_()));
            this.f_19804_.m_135381_(OWNER_YAW_HEAD, (Object)Float.valueOf(this.cachedOwner.m_6080_()));
            CompoundTag inventoryTag = new CompoundTag();
            ItemStack mainHand = this.cachedOwner.m_21205_();
            if (!mainHand.m_41619_()) {
                CompoundTag mainHandTag = new CompoundTag();
                mainHand.m_41739_(mainHandTag);
                inventoryTag.m_128365_("MainHand", (Tag)mainHandTag);
            }
            if (!(offHand = this.cachedOwner.m_21206_()).m_41619_()) {
                CompoundTag offHandTag = new CompoundTag();
                offHand.m_41739_(offHandTag);
                inventoryTag.m_128365_("OffHand", (Tag)offHandTag);
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = this.cachedOwner.m_150109_().m_36052_(i);
                if (armor.m_41619_()) continue;
                CompoundTag armorTag = new CompoundTag();
                armor.m_41739_(armorTag);
                inventoryTag.m_128365_("Armor" + i, (Tag)armorTag);
            }
            this.f_19804_.m_135381_(OWNER_INVENTORY, (Object)inventoryTag);
            this.updateOwnerStatusInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateOwnerStatusInfo() {
        if (this.cachedOwner == null) {
            return;
        }
        StringBuilder statusBuilder = new StringBuilder();
        if (this.hasDisplayFlag(8)) {
            statusBuilder.append(String.format("Health: %.1f/%.1f", Float.valueOf(this.cachedOwner.m_21223_()), Float.valueOf(this.cachedOwner.m_21233_())));
        }
        if (statusBuilder.length() > 0) {
            statusBuilder.append("\n");
        }
        statusBuilder.append(String.format("Armor: %.1f", this.cachedOwner.m_21230_()));
        if (this.hasDisplayFlag(16)) {
            FoodData foodData = this.cachedOwner.m_36324_();
            if (statusBuilder.length() > 0) {
                statusBuilder.append("\n");
            }
            statusBuilder.append(String.format("Hunger: %d/20", foodData.m_38702_()));
        }
        if (this.hasDisplayFlag(32)) {
            if (statusBuilder.length() > 0) {
                statusBuilder.append("\n");
            }
            statusBuilder.append(String.format("XP: %d (Lvl %d)", this.cachedOwner.f_36079_, this.cachedOwner.f_36078_));
        }
        if (this.hasDisplayFlag(64)) {
            if (statusBuilder.length() > 0) {
                statusBuilder.append("\n");
            }
            statusBuilder.append(String.format("Pos: %.1f, %.1f, %.1f", this.cachedOwner.m_20185_(), this.cachedOwner.m_20186_(), this.cachedOwner.m_20189_()));
        }
        if (this.hasDisplayFlag(128)) {
            if (statusBuilder.length() > 0) {
                statusBuilder.append("\n");
            }
            String dimensionName = this.cachedOwner.m_9236_().m_46472_().m_135782_().toString();
            statusBuilder.append(String.format("Dim: %s", dimensionName));
        }
        this.f_19804_.m_135381_(OWNER_STATUS_INFO, (Object)statusBuilder.toString());
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.ownerUUID != null) {
            ShabtiItem.removeShabti(this.ownerUUID);
        }
    }

    public float getOwnerYaw() {
        return ((Float)this.f_19804_.m_135370_(OWNER_YAW)).floatValue();
    }

    public float getOwnerPitch() {
        return ((Float)this.f_19804_.m_135370_(OWNER_PITCH)).floatValue();
    }

    public float getOwnerYawHead() {
        return ((Float)this.f_19804_.m_135370_(OWNER_YAW_HEAD)).floatValue();
    }

    public CompoundTag getOwnerInventory() {
        return (CompoundTag)this.f_19804_.m_135370_(OWNER_INVENTORY);
    }

    public UUID getOwnerUUID() {
        if (this.ownerUUID == null && !((String)this.f_19804_.m_135370_(OWNER_UUID)).isEmpty()) {
            this.ownerUUID = UUID.fromString((String)this.f_19804_.m_135370_(OWNER_UUID));
        }
        return this.ownerUUID;
    }

    public void setOwner(ServerPlayer owner) {
        this.ownerUUID = owner.m_20148_();
        this.cachedOwner = owner;
        this.f_19804_.m_135381_(OWNER_UUID, (Object)owner.m_20148_().toString());
        this.updateFromOwner();
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.ownerUUID != null && this.ownerUUID.equals(player.m_20148_())) {
                this.m_21153_(0.0f);
                boolean actuallyHurt = super.m_6469_(damageSource, amount);
                if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!this.m_6084_()) {
                        ShabtiItem.giveShabtiItem(serverPlayer);
                        player.m_213846_((Component)Component.m_237113_((String)"Shabti returned to your inventory"));
                    }
                }
                return actuallyHurt;
            }
        }
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    protected void m_6138_() {
    }

    public Iterable<ItemStack> m_6168_() {
        ArrayList<ItemStack> armorItems = new ArrayList<ItemStack>();
        CompoundTag inventoryTag = this.getOwnerInventory();
        for (int i = 0; i < 4; ++i) {
            if (inventoryTag.m_128441_("Armor" + i)) {
                armorItems.add(ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Armor" + i)));
                continue;
            }
            armorItems.add(ItemStack.f_41583_);
        }
        return armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        CompoundTag inventoryTag = this.getOwnerInventory();
        switch (slot) {
            case MAINHAND: {
                if (!inventoryTag.m_128441_("MainHand")) break;
                return ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("MainHand"));
            }
            case OFFHAND: {
                if (!inventoryTag.m_128441_("OffHand")) break;
                return ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("OffHand"));
            }
            case HEAD: {
                if (!inventoryTag.m_128441_("Armor3")) break;
                return ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Armor3"));
            }
            case CHEST: {
                if (!inventoryTag.m_128441_("Armor2")) break;
                return ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Armor2"));
            }
            case LEGS: {
                if (!inventoryTag.m_128441_("Armor1")) break;
                return ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Armor1"));
            }
            case FEET: {
                if (!inventoryTag.m_128441_("Armor0")) break;
                return ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Armor0"));
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        if (this.cachedOwner != null) {
            return this.cachedOwner.m_5737_();
        }
        return HumanoidArm.RIGHT;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("OwnerUUID")) {
            this.ownerUUID = UUID.fromString(compound.m_128461_("OwnerUUID"));
            this.f_19804_.m_135381_(OWNER_UUID, (Object)compound.m_128461_("OwnerUUID"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.ownerUUID != null) {
            compound.m_128359_("OwnerUUID", this.ownerUUID.toString());
        }
    }

    protected void registerGoals() {
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public boolean hasDisplayFlag(int flag) {
        return ((Integer)this.f_19804_.m_135370_(DISPLAY_FLAGS) & flag) != 0;
    }

    public void setDisplayFlag(int flag, boolean enabled) {
        int currentFlags = (Integer)this.f_19804_.m_135370_(DISPLAY_FLAGS);
        currentFlags = enabled ? (currentFlags |= flag) : (currentFlags &= ~flag);
        this.f_19804_.m_135381_(DISPLAY_FLAGS, (Object)currentFlags);
        this.displayFlags = currentFlags;
    }

    public int getDisplayFlags() {
        return (Integer)this.f_19804_.m_135370_(DISPLAY_FLAGS);
    }

    public String getOwnerStatusInfo() {
        return (String)this.f_19804_.m_135370_(OWNER_STATUS_INFO);
    }

    public InteractionResult m_7111_(Player player, Vec3 hitVec, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ItemStack heldItem;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.ownerUUID != null && this.ownerUUID.equals(player.m_20148_()) && !((heldItem = player.m_21120_(hand)).m_41720_() instanceof ShabtiItem)) {
                if (heldItem.m_41619_()) {
                    player.m_213846_((Component)Component.m_237113_((String)"Punch the Shabti to recall it"));
                    return InteractionResult.SUCCESS;
                }
                player.m_213846_((Component)Component.m_237113_((String)"Shabti Configuration GUI will be implemented"));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_7111_(player, hitVec, hand);
    }

    public Component m_5446_() {
        ServerPlayer owner;
        if (this.cachedOwner != null) {
            return Component.m_237113_((String)(this.cachedOwner.m_5446_().getString() + "'s Shabti"));
        }
        if (this.ownerUUID != null && this.m_9236_().m_7654_() != null && (owner = this.m_9236_().m_7654_().m_6846_().m_11259_(this.ownerUUID)) != null) {
            return Component.m_237113_((String)(owner.m_5446_().getString() + "'s Shabti"));
        }
        return Component.m_237113_((String)"Shabti");
    }

    public boolean m_8077_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }
}

