/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.common.loot.SurvivalistEssentialsLootConditionTypes;

public record LootItemBlockIsTagCondition(TagKey<Block> tag) implements LootItemCondition
{
    public static final LootItemConditionType LOOT_ITEM_BLOCK_IS_TAG = new LootItemConditionType(CODEC);
    public static final MapCodec<LootItemBlockIsTagCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("tag").forGetter(LootItemBlockIsTagCondition::tag)).apply((Applicative)builder, LootItemBlockIsTagCondition::new));

    public static LootItemBlockIsTagCondition isTag(TagKey<Block> tag) {
        return new LootItemBlockIsTagCondition(tag);
    }

    @NotNull
    public LootItemConditionType getType() {
        return SurvivalistEssentialsLootConditionTypes.BLOCK_IS_TAG;
    }

    public boolean test(LootContext lootContext) {
        BlockState state = (BlockState)lootContext.getParamOrNull(LootContextParams.BLOCK_STATE);
        return state != null && state.is(this.tag);
    }
}

