/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.common.TagManager;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.mixin.AbstractBlockStateAccessor;
import survivalistessentials.util.ToolType;
import technology.roughness.whitenoise.platform.Services;

public class ItemUse {
    private static final Map<String, String> toolsMap = new HashMap<String, String>();
    public static final List<String> TOOL_TYPES = new ArrayList<String>(Arrays.asList("pickaxe", "pickadze", "bow", "crossbow", "axe", "hatchet", "hoe", "mattock", "kama", "shears", "shovel", "sword", "weapon", "hammer", "wirecutter", "wrench", "drill", "building", "revolver", "saw", "crook", "spell", "knife", "cad", "spear", "darkstar", "chisel"));

    public static void init() {
        toolsMap.clear();
        for (String string : ConfigHandler.Common.getItems()) {
            String[] nameParts = string.split("-");
            String toolType = nameParts[0];
            if (!TOOL_TYPES.contains(toolType)) continue;
            toolsMap.put(nameParts[1], nameParts[0]);
        }
    }

    public static boolean isAllowedTool(ItemStack stack) {
        ResourceLocation loc = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String itemName = loc.getPath();
        String modid = loc.getNamespace();
        boolean hasTag = ItemUse.hasTag(stack);
        if (ConfigHandler.Common.invertListToWhitelist()) {
            return hasTag || ConfigHandler.Common.getMods().contains(modid) || toolsMap.get(itemName) != null;
        }
        return !hasTag && !ConfigHandler.Common.getMods().contains(modid) && toolsMap.get(itemName) == null;
    }

    public static String getModId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace();
    }

    public static boolean alwaysDrops(BlockState state) {
        if (((AbstractBlockStateAccessor)state).getDestroySpeed() == 0.0f) {
            return true;
        }
        return state.is(TagManager.Blocks.ALWAYS_DROPS);
    }

    public static String getToolClass(ItemStack stack) {
        String itemName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        String type = toolsMap.get(itemName);
        if (ToolType.PICKAXE.is(stack.getItem())) {
            type = "pickaxe";
        } else if (ToolType.AXE.is(stack.getItem())) {
            type = "axe";
        } else if (ToolType.SHOVEL.is(stack.getItem())) {
            type = "shovel";
        } else if (ToolType.HOE.is(stack.getItem())) {
            type = "hoe";
        } else if (ToolType.SHARP.is(stack.getItem())) {
            type = "sharp";
        }
        if (type == null) {
            String[] nameParts = itemName.split("[^a-z]+");
            for (String toolType : TOOL_TYPES) {
                if (!itemName.contains(toolType) || !Arrays.asList(nameParts).contains(toolType)) continue;
                type = toolType;
            }
        }
        return Objects.requireNonNullElse(type, "unknown");
    }

    public static boolean isCorrectToolType(String type, ItemStack handStack) {
        boolean isCorrectToolType = false;
        String toolClass = ItemUse.getToolClass(handStack);
        switch (type) {
            case "pickaxe": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("drill") || toolClass.equals("pickadze") || toolClass.equals("building") || toolClass.equals("hammer") || toolClass.equals("spell") || toolClass.equals("cad") || toolClass.equals("chisel") || ToolType.PICKAXE.is(handStack.getItem());
                break;
            }
            case "axe": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("mattock") || toolClass.equals("building") || toolClass.equals("spell") || toolClass.equals("cad") || toolClass.equals("hatchet") || ToolType.AXE.is(handStack.getItem());
                break;
            }
            case "shovel": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("mattock") || toolClass.equals("drill") || toolClass.equals("pickadze") || toolClass.equals("building") || toolClass.equals("spell") || toolClass.equals("cad") || ToolType.SHOVEL.is(handStack.getItem());
                break;
            }
            case "hoe": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("mattock") || toolClass.equals("building") || toolClass.equals("crook") || toolClass.equals("spell") || toolClass.equals("cad") || ToolType.HOE.is(handStack.getItem());
                break;
            }
            case "sharp": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("knife") || toolClass.equals("mattock") || toolClass.equals("building") || toolClass.equals("spell") || toolClass.equals("axe") || toolClass.equals("modular_sword") || ToolType.SHARP.is(handStack.getItem());
            }
        }
        return isCorrectToolType;
    }

    public static boolean isAlwaysBreakable(BlockState state) {
        if (((AbstractBlockStateAccessor)state).getDestroySpeed() == 0.0f) {
            if (!Services.PLATFORM.isModLoaded("dynamictrees")) {
                return true;
            }
            return !state.is(TagManager.Blocks.BRANCHES);
        }
        return false;
    }

    public static boolean isCorrectTool(BlockState state, Player player, ItemStack handStack) {
        if (ItemUse.isAlwaysBreakable(state)) {
            return true;
        }
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE) && ItemUse.isCorrectToolType("pickaxe", handStack)) {
            return true;
        }
        if (state.is(BlockTags.MINEABLE_WITH_AXE) && ItemUse.isCorrectToolType("axe", handStack)) {
            return true;
        }
        if (state.is(BlockTags.MINEABLE_WITH_SHOVEL) && ItemUse.isCorrectToolType("shovel", handStack)) {
            return true;
        }
        if (state.is(BlockTags.MINEABLE_WITH_HOE) && ItemUse.isCorrectToolType("hoe", handStack)) {
            return true;
        }
        if (state.is(TagManager.Blocks.MINEABLE_WITH_SHARP) && ItemUse.isCorrectToolType("sharp", handStack)) {
            return true;
        }
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.getBlock(), ToolType.NONE);
        if (expectedToolType == ToolType.NONE) {
            return true;
        }
        if (ItemUse.isCorrectToolType(expectedToolType.toString().toLowerCase(), handStack)) {
            return true;
        }
        ToolType inferredToolType = HarvestBlock.ITEM_TOOL_TYPES.getOrDefault(handStack.getItem(), ToolType.NONE);
        if (inferredToolType == expectedToolType) {
            return true;
        }
        return expectedToolType.is(handStack.getItem());
    }

    public static boolean isArmor(ItemStack stack) {
        return stack.getItem() instanceof ArmorItem;
    }

    public static boolean isAllowedArmor(ItemStack stack) {
        ResourceLocation loc = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String itemName = loc.getPath();
        String modid = loc.getNamespace();
        boolean hasTag = ItemUse.hasTag(stack);
        if (ConfigHandler.Common.invertListToWhitelist()) {
            return hasTag || ConfigHandler.Common.armorMods().contains(modid) || ConfigHandler.Common.armorItems().contains(itemName);
        }
        return !hasTag && !ConfigHandler.Common.armorMods().contains(modid) && !ConfigHandler.Common.armorItems().contains(itemName);
    }

    public static boolean hasTag(ItemStack stack) {
        return ConfigHandler.Common.tagList().stream().anyMatch(arg_0 -> ((ItemStack)stack).is(arg_0));
    }
}

