/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class Lazy<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    @Nullable
    private volatile T cachedValue;

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    public synchronized void invalidate() {
        this.cachedValue = null;
    }

    private Lazy(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T ret = this.cachedValue;
        if (ret == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                ret = this.cachedValue;
                if (ret == null) {
                    this.cachedValue = ret = this.delegate.get();
                    if (ret == null) {
                        throw new IllegalStateException("Lazy value cannot be null, but supplier returned null: " + String.valueOf(this.delegate));
                    }
                }
            }
        }
        return ret;
    }
}

