/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.loot;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.common.TagManager;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.loot.SurvivalistEssentialsLootTables;
import survivalistessentials.util.LootConditionHelper;

public class GlobalLootModifier
extends GlobalLootModifierProvider {
    public GlobalLootModifier(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider, "survivalistessentials");
    }

    @NotNull
    public String getName() {
        return "SurvivalistEssentials - Global Loot Modifier";
    }

    protected void start() {
        this.addPlantFiberDrops(TagManager.Blocks.FIBER_PLANTS, "fiber_plants");
        this.addStickDrops((TagKey<Block>)BlockTags.LEAVES, "leaves");
    }

    public void addPlantFiberDrops(TagKey<Block> tag, String name) {
        HolderLookup.RegistryLookup itemRegistryLookup = this.registries.lookupOrThrow(Registries.ITEM);
        this.add("plant_fiber_from_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(LootConditionHelper.createKnifeChanceCondition(0.16f, tag, (HolderLookup.RegistryLookup<Item>)itemRegistryLookup), new ItemStack((ItemLike)SurvivalistEssentialsItems.PLANT_FIBER)), new ICondition[0]);
    }

    public void addStickDrops(TagKey<Block> tag, String name) {
        HolderLookup.RegistryLookup enchantmentRegistryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        HolderLookup.RegistryLookup itemRegistryLookup = this.registries.lookupOrThrow(Registries.ITEM);
        HolderLookup.RegistryLookup entityRegistryLookup = this.registries.lookupOrThrow(Registries.ENTITY_TYPE);
        this.add("stick_drops_from_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(LootConditionHelper.createKnifeChanceCondition(0.16f, tag, (HolderLookup.RegistryLookup<Item>)itemRegistryLookup), new ItemStack((ItemLike)Items.STICK)), new ICondition[0]);
        this.add("extra_stick_drops_from_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(LootConditionHelper.createExtraStickDropConditions(0.16f, tag, (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistryLookup, (HolderLookup.RegistryLookup<Item>)itemRegistryLookup, entityRegistryLookup), new ItemStack((ItemLike)Items.STICK)), new ICondition[0]);
    }
}

