/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.recipe;

import java.util.Map;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.common.TagManager;
import survivalistessentials.data.integration.SurvivalistEssentialsIntegration;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.world.SurvivalistEssentialsWorld;

public interface ISurvivalistEssentialsRecipeProvider {
    public RecipeOutput modLoaded(RecipeOutput var1, String var2);

    public RecipeOutput modNotLoaded(RecipeOutput var1, String var2);

    public RecipeOutput configResourceCondition(RecipeOutput var1, String var2);

    public Criterion<InventoryChangeTrigger.TriggerInstance> _has(ItemLike var1);

    public Criterion<InventoryChangeTrigger.TriggerInstance> _has(TagKey<Item> var1);

    default public void buildModRecipes(HolderLookup.Provider registries, @NotNull RecipeOutput recipeOutput) {
        HolderLookup.RegistryLookup itemRegistry = registries.lookupOrThrow(Registries.ITEM);
        Item rockStone = SurvivalistEssentialsWorld.ROCK_STONE;
        Item flintShard = SurvivalistEssentialsItems.FLINT_SHARD;
        Item plantFiber = SurvivalistEssentialsItems.PLANT_FIBER;
        Item plantString = SurvivalistEssentialsItems.PLANT_STRING;
        Item mortar = SurvivalistEssentialsItems.MORTAR_AND_PESTLE;
        Item plantPaste = SurvivalistEssentialsItems.PLANT_PASTE;
        Item ointment = SurvivalistEssentialsItems.OINTMENT;
        Item cloth = SurvivalistEssentialsItems.CLOTH;
        Item crudeKnife = SurvivalistEssentialsItems.CRUDE_KNIFE;
        Map<ResourceLocation, Item> cookedMeats = Map.of(ResourceLocationHelper.loc((String)"aquaculture", (String)"fish_fillet_cooked"), SurvivalistEssentialsIntegration.AQUA_FISH_FILLET_COOKED, ResourceLocationHelper.loc((String)"aquaculture", (String)"frog_legs_cooked"), SurvivalistEssentialsIntegration.AQUA_FROG_LEGS_COOKED, ResourceLocationHelper.loc((String)"minecraft", (String)"cooked_beef"), Items.COOKED_BEEF, ResourceLocationHelper.loc((String)"minecraft", (String)"cooked_chicken"), Items.COOKED_CHICKEN, ResourceLocationHelper.loc((String)"minecraft", (String)"cooked_mutton"), Items.COOKED_MUTTON, ResourceLocationHelper.loc((String)"minecraft", (String)"cooked_porkchop"), Items.COOKED_PORKCHOP, ResourceLocationHelper.loc((String)"minecraft", (String)"cooked_rabbit"), Items.COOKED_RABBIT, ResourceLocationHelper.loc((String)"minecraft", (String)"cooked_cod"), Items.COOKED_COD, ResourceLocationHelper.loc((String)"minecraft", (String)"cooked_salmon"), Items.COOKED_SALMON);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('R'), (ItemLike)rockStone).pattern("RR").pattern("RR").unlockedBy("has_loose_rock", this._has((ItemLike)rockStone)).save(recipeOutput, ResourceLocationHelper.prefix("cobblestone_from_rocks").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)rockStone, (int)4).requires((ItemLike)Blocks.COBBLESTONE).unlockedBy("has_cobblestone", this._has((ItemLike)Blocks.COBBLESTONE)).save(recipeOutput, ResourceLocationHelper.prefix("rocks_from_cobblestone").toString());
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.FLINT).define(Character.valueOf('S'), (ItemLike)flintShard).pattern("SS").pattern("SS").unlockedBy("has_flint_shard", this._has((ItemLike)flintShard)).save(recipeOutput, ResourceLocationHelper.prefix("flint_from_shards").toString());
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)plantString).define(Character.valueOf('F'), (ItemLike)plantFiber).pattern("FF").pattern("F ").unlockedBy("has_plant_fiber", this._has((ItemLike)plantFiber)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)plantPaste).define(Character.valueOf('F'), (ItemLike)plantFiber).define(Character.valueOf('U'), (ItemLike)mortar).pattern("F").pattern("U").unlockedBy("has_plant_fiber", this._has((ItemLike)plantFiber)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ointment).define(Character.valueOf('P'), (ItemLike)plantPaste).pattern("PP").pattern("PP").unlockedBy("has_plant_paste", this._has((ItemLike)plantPaste)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)cloth).define(Character.valueOf('S'), TagManager.Items.STRINGS).pattern("SSS").unlockedBy("has_string", this._has(TagManager.Items.STRINGS)).save(recipeOutput);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)plantString), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (float)0.1f, (int)50).unlockedBy("has_plant_string", this._has((ItemLike)plantString)).save(recipeOutput, ResourceLocationHelper.prefix("string_from_plant_string").toString());
        RecipeOutput wrapped = this.modNotLoaded(recipeOutput, "tinkersurvival");
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.CRUDE_SAW_BLADE).define(Character.valueOf('D'), (ItemLike)flintShard).define(Character.valueOf('S'), (ItemLike)plantString).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("ID").pattern("SD").unlockedBy("has_plant_string", this._has((ItemLike)plantString)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.BASIC_SAW_BLADE).define(Character.valueOf('D'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), TagManager.Items.STRINGS).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("ID").pattern("SD").unlockedBy("has_iron_ingot", this._has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SHARP_SAW_BLADE).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('S'), TagManager.Items.STRINGS).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("ID").pattern("SD").unlockedBy("has_diamond", this._has((ItemLike)Items.DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)crudeKnife).define(Character.valueOf('S'), (ItemLike)flintShard).define(Character.valueOf('T'), (ItemLike)Items.STICK).pattern("S").pattern("T").unlockedBy("has_flint_shard", this._has((ItemLike)flintShard)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.BASIC_KNIFE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('X'), TagManager.Items.STRINGS).pattern("IX").pattern(" S").unlockedBy("has_iron_ingot", this._has((ItemLike)Items.IRON_INGOT)).save(wrapped);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SHARP_KNIFE).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('X'), TagManager.Items.STRINGS).pattern("DX").pattern(" S").unlockedBy("has_diamond", this._has((ItemLike)Items.DIAMOND)).save(wrapped);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.CRUDE_HATCHET).define(Character.valueOf('R'), (ItemLike)rockStone).define(Character.valueOf('S'), (ItemLike)plantString).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("SR").pattern("I ").unlockedBy("has_loose_rock", this._has((ItemLike)rockStone)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('S'), (ItemLike)plantString).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("IS").pattern(" I").unlockedBy("has_plant_string", this._has((ItemLike)plantString)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).define(Character.valueOf('H'), (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('B'), (ItemLike)SurvivalistEssentialsItems.CRUDE_SAW_BLADE).define(Character.valueOf('S'), (ItemLike)plantString).pattern("BS").pattern(" H").unlockedBy("has_crude_saw_handle", this._has((ItemLike)SurvivalistEssentialsItems.SAW_HANDLE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.BASIC_SAW).define(Character.valueOf('H'), (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('B'), (ItemLike)SurvivalistEssentialsItems.BASIC_SAW_BLADE).define(Character.valueOf('S'), TagManager.Items.STRINGS).pattern("BS").pattern(" H").unlockedBy("has_iron_ingot", this._has((ItemLike)Items.IRON_INGOT)).save(wrapped);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SHARP_SAW).define(Character.valueOf('H'), (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('B'), (ItemLike)SurvivalistEssentialsItems.SHARP_SAW_BLADE).define(Character.valueOf('S'), TagManager.Items.STRINGS).pattern("BS").pattern(" H").unlockedBy("has_diamond", this._has((ItemLike)Items.DIAMOND)).save(wrapped);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)mortar).define(Character.valueOf('I'), (ItemLike)Items.STICK).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)rockStone).pattern("  I").pattern("PRP").pattern(" P ").unlockedBy("has_plant_fiber", this._has((ItemLike)plantFiber)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK).requires(ItemTags.SAPLINGS).requires(TagManager.Items.KNIFE_TOOLS).group("sticks").unlockedBy("has_sapling", this._has((TagKey<Item>)ItemTags.SAPLINGS)).save(recipeOutput, ResourceLocationHelper.prefix("stick_from_sapling").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (int)2).requires(ItemTags.WOOL).requires((ItemLike)crudeKnife).group("string").unlockedBy("has_wool", this._has((TagKey<Item>)ItemTags.WOOL)).save(recipeOutput, ResourceLocationHelper.prefix("string_from_wool").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (int)4).requires(ItemTags.WOOL).requires(TagManager.Items.ADVANCED_KNIFE_TOOLS).group("string").unlockedBy("has_wool", this._has((TagKey<Item>)ItemTags.WOOL)).save(recipeOutput, ResourceLocationHelper.prefix("string_from_wool_advanced").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)flintShard, (int)2).requires((ItemLike)SurvivalistEssentialsWorld.ROCK_STONE).requires(TagManager.Items.KNIFE_TOOLS).group("flint_shards").unlockedBy("has_crude_knife", this._has((ItemLike)crudeKnife)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)flintShard, (int)4).requires((ItemLike)Items.FLINT).requires(TagManager.Items.KNIFE_TOOLS).group("flint_shards").unlockedBy("has_crude_knife", this._has((ItemLike)crudeKnife)).save(recipeOutput, ResourceLocationHelper.prefix("flint_shards_from_flint").toString());
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsItems.CRUDE_BANDAGE).define(Character.valueOf('P'), (ItemLike)plantString).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('F'), (ItemLike)plantFiber).pattern("SF").pattern("PF").unlockedBy("has_plant_string", this._has((ItemLike)plantString)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsItems.BANDAGE).define(Character.valueOf('P'), (ItemLike)plantString).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('C'), (ItemLike)cloth).define(Character.valueOf('O'), (ItemLike)ointment).pattern("SC").pattern("PO").unlockedBy("has_ointment", this._has((ItemLike)ointment)).save(recipeOutput);
        for (Map.Entry<ResourceLocation, Item> cookedMeat : cookedMeats.entrySet()) {
            if (cookedMeat.getKey().getNamespace().equals("minecraft")) {
                this.smokedLeatherRecipeBuilder(recipeOutput, (ItemLike)cookedMeat.getValue(), cookedMeat.getKey().getPath());
                continue;
            }
            wrapped = this.modLoaded(recipeOutput, cookedMeat.getKey().getNamespace());
            this.smokedLeatherRecipeBuilder(wrapped, (ItemLike)cookedMeat.getValue(), cookedMeat.getKey().getPath());
        }
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsItems.BOOK).requires((ItemLike)SurvivalistEssentialsWorld.ROCK_STONE).group("books").unlockedBy("has_loose_rock", this._has((ItemLike)rockStone)).save(recipeOutput, ResourceLocationHelper.prefix("book_from_rocks").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SurvivalistEssentialsWorld.ROCK_STONE).requires((ItemLike)SurvivalistEssentialsItems.BOOK).group("books").unlockedBy("has_intro_book", this._has((ItemLike)SurvivalistEssentialsItems.BOOK)).save(recipeOutput, ResourceLocationHelper.prefix("rock_from_book").toString());
        wrapped = this.configResourceCondition(recipeOutput, "enableModpackBook");
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsItems.MODPACK_BOOK).requires((ItemLike)SurvivalistEssentialsWorld.ROCK_STONE).requires((ItemLike)SurvivalistEssentialsWorld.ROCK_STONE).group("books").unlockedBy("has_loose_rock", this._has((ItemLike)rockStone)).save(wrapped, ResourceLocationHelper.prefix("modpack_book_from_rocks").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SurvivalistEssentialsWorld.ROCK_STONE, (int)2).requires((ItemLike)SurvivalistEssentialsItems.MODPACK_BOOK).group("books").unlockedBy("has_modpack_book", this._has((ItemLike)SurvivalistEssentialsItems.MODPACK_BOOK)).save(wrapped, ResourceLocationHelper.prefix("rocks_from_modpack_book").toString());
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.OAK_PLANKS, (TagKey<Item>)ItemTags.OAK_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.ACACIA_PLANKS, (TagKey<Item>)ItemTags.ACACIA_LOGS, "has_log", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.BIRCH_PLANKS, (TagKey<Item>)ItemTags.BIRCH_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.DARK_OAK_PLANKS, (TagKey<Item>)ItemTags.DARK_OAK_LOGS, "has_log", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.JUNGLE_PLANKS, (TagKey<Item>)ItemTags.JUNGLE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.SPRUCE_PLANKS, (TagKey<Item>)ItemTags.SPRUCE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.WARPED_PLANKS, (TagKey<Item>)ItemTags.WARPED_STEMS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.CRIMSON_PLANKS, (TagKey<Item>)ItemTags.CRIMSON_STEMS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.MANGROVE_PLANKS, (TagKey<Item>)ItemTags.MANGROVE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.CHERRY_PLANKS, (TagKey<Item>)ItemTags.CHERRY_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.bambooRecipeBuilder(recipeOutput, (ItemLike)Blocks.BAMBOO_PLANKS, (TagKey<Item>)ItemTags.BAMBOO_BLOCKS, "has_bamboo_block", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "fruitfulfun");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.CHERRY_PLANKS, TagManager.Items.CHERRY_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.CITRUS_PLANKS, TagManager.Items.CITRUS_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "biomemakeover");
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_ANCIENT_OAK_LOG, "has_logs", "wood/ancient_oak/", "ancient_oak_planks", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_STRIPPED_ANCIENT_OAK_LOG, "has_logs", "wood/ancient_oak/", "ancient_oak_planks_stripped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_ANCIENT_OAK_WOOD, "has_logs", "wood/ancient_oak/", "ancient_oak_planks_wood", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_STRIPPED_ANCIENT_OAK_WOOD, "has_logs", "wood/ancient_oak/", "ancient_oak_planks_wood_stripped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_BLIGHTED_BALSA_LOG, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_STRIPPED_BLIGHTED_BALSA_LOG, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks_stripped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_BLIGHTED_BALSA_WOOD, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks_wood", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_STRIPPED_BLIGHTED_BALSA_WOOD, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks_wood_stipped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_SWAMP_CYPRESS_LOG, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_STRIPPED_SWAMP_CYPRESS_LOG, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks_stripped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_SWAMP_CYPRESS_WOOD, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks_wood", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_STRIPPED_SWAMP_CYPRESS_WOOD, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks_wood_stripped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_WILLOW_LOG, "has_logs", "wood/willow/", "willow_planks", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_STRIPPED_WILLOW_LOG, "has_logs", "wood/willow/", "willow_planks_stripped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_WILLOW_WOOD, "has_logs", "wood/willow/", "willow_planks_wood", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_STRIPPED_WILLOW_WOOD, "has_logs", "wood/willow/", "willow_planks_wood_stripped", "biomemakeover", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "biomesoplenty");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_DEAD_PLANKS, TagManager.Items.BOP_DEAD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_FIR_PLANKS, TagManager.Items.BOP_FIR_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_HELLBARK_PLANKS, TagManager.Items.BOP_HELLBARK_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_JACARANDA_PLANKS, TagManager.Items.BOP_JACARANDA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_MAGIC_PLANKS, TagManager.Items.BOP_MAGIC_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_MAHOGANY_PLANKS, TagManager.Items.BOP_MAHOGANY_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_PALM_PLANKS, TagManager.Items.BOP_PALM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_REDWOOD_PLANKS, TagManager.Items.BOP_REDWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_UMBRAN_PLANKS, TagManager.Items.BOP_UMBRAN_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_WILLOW_PLANKS, TagManager.Items.BOP_WILLOW_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "quark");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.QUARK_AZALEA_PLANKS, TagManager.Items.QUARK_AZALEA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.QUARK_BLOSSOM_PLANKS, TagManager.Items.QUARK_BLOSSOM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "allyoucaneat");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.AYCE_HAZEL_PLANKS, TagManager.Items.AYCE_HAZEL_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "tconstruct");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TCON_BLOODSHROOM_PLANKS, TagManager.Items.TCON_BLOODSHROOM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TCON_GREENHEART_PLANKS, TagManager.Items.TCON_GREENHEART_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TCON_SKYROOT_PLANKS, TagManager.Items.TCON_SKYROOT_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "watersource");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.WS_PALM_TREE_PLANKS, TagManager.Items.WS_PALM_TREE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "botania");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOTANIA_DREAMWOOD_PLANKS, TagManager.Items.BOTANIA_DREAMWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOTANIA_LIVINGWOOD_PLANKS, TagManager.Items.BOTANIA_LIVINGWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "ars_nouveau");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.AN_ARCHWOOD_PLANKS, TagManager.Items.ARCHWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "undergarden");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.UNDERGARDEN_GRONGLE_PLANKS, TagManager.Items.UNDERGARDEN_GRONGLE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.UNDERGARDEN_SMOGSTEM_PLANKS, TagManager.Items.UNDERGARDEN_SMOGSTEM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.UNDERGARDEN_WIGGLEWOOD_PLANKS, TagManager.Items.UNDERGARDEN_WIGGLEWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "biomeswevegone");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_WHITE_MANGROVE_PLANKS, TagManager.Items.BYG_WHITE_MANGROVE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_REDWOOD_PLANKS, TagManager.Items.BYG_REDWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_BLUE_ENCHANTED_PLANKS, TagManager.Items.BYG_BLUE_ENCHANTED_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_GREEN_ENCHANTED_PLANKS, TagManager.Items.BYG_GREEN_ENCHANTED_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_MAHOGANY_PLANKS, TagManager.Items.BYG_MAHOGANY_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_BAOBAB_PLANKS, TagManager.Items.BYG_BAOBAB_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_JACARANDA_PLANKS, TagManager.Items.BYG_JACARANDA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_CYPRESS_PLANKS, TagManager.Items.BYG_CYPRESS_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_PALM_PLANKS, TagManager.Items.BYG_PALM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_EBONY_PLANKS, TagManager.Items.BYG_EBONY_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_RAINBOW_EUCALYPTUS_PLANKS, TagManager.Items.BYG_RAINBOW_EUCALYPTUS_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_ASPEN_PLANKS, TagManager.Items.BYG_ASPEN_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_FIR_PLANKS, TagManager.Items.BYG_FIR_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_SKYRIS_PLANKS, TagManager.Items.BYG_SKYRIS_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_CIKA_PLANKS, TagManager.Items.BYG_CIKA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_HOLLY_PLANKS, TagManager.Items.BYG_HOLLY_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_MAPLE_PLANKS, TagManager.Items.BYG_MAPLE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_PINE_PLANKS, TagManager.Items.BYG_PINE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_WILLOW_PLANKS, TagManager.Items.BYG_WILLOW_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_WITCH_HAZEL_PLANKS, TagManager.Items.BYG_WITCH_HAZEL_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_ZELKOVA_PLANKS, TagManager.Items.BYG_ZELKOVA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_IRONWOOD_PLANKS, TagManager.Items.BYG_IRONWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_SAKURA_PLANKS, TagManager.Items.BYG_SAKURA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_PALO_VERDE_PLANKS, TagManager.Items.BYG_PALO_VERDE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_SPIRIT_PLANKS, TagManager.Items.BYG_SPIRIT_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_FLORUS_STEM, TagManager.Items.BYG_FLORUS_STEMS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "twilightforest");
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_LOG, "has_logs", "wood/", "canopy_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_STRIPPED_LOG, "has_logs", "wood/", "canopy_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_WOOD, "has_logs", "wood/", "canopy_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_STRIPPED_WOOD, "has_logs", "wood/", "canopy_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_LOG, "has_logs", "wood/", "darkwood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_STRIPPED_LOG, "has_logs", "wood/", "darkwood_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_WOOD, "has_logs", "wood/", "darkwood_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_STRIPPED_WOOD, "has_logs", "wood/", "darkwood_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_LOG, "has_logs", "wood/", "mangrove_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_STRIPPED_LOG, "has_logs", "wood/", "mangrove_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_WOOD, "has_logs", "wood/", "mangrove_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_STRIPPED_WOOD, "has_logs", "wood/", "mangrove_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_LOG, "has_logs", "wood/", "mining_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_STRIPPED_LOG, "has_logs", "wood/", "mining_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_WOOD, "has_logs", "wood/", "mining_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_STRIPPED_WOOD, "has_logs", "wood/", "mining_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_LOG, "has_logs", "wood/", "sorting_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_STRIPPED_LOG, "has_logs", "wood/", "sorting_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_WOOD, "has_logs", "wood/", "sorting_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_STRIPPED_WOOD, "has_logs", "wood/", "sorting_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_LOG, "has_logs", "wood/", "time_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_STRIPPED_LOG, "has_logs", "wood/", "time_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_WOOD, "has_logs", "wood/", "time_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_STRIPPED_WOOD, "has_logs", "wood/", "time_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_LOG, "has_logs", "wood/", "transformation_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_STRIPPED_LOG, "has_logs", "wood/", "transformation_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_WOOD, "has_logs", "wood/", "transformation_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_STRIPPED_WOOD, "has_logs", "wood/", "transformation_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_LOG, "has_logs", "wood/", "twilight_oak_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_STRIPPED_LOG, "has_logs", "wood/", "twilight_oak_from_stripped_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_WOOD, "has_logs", "wood/", "twilight_oak_from_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_STRIPPED_WOOD, "has_logs", "wood/", "twilight_oak_from_stripped_wood_planks", "twilightforest", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.OAK_PLANKS, (int)64).requires(TagManager.Items.TF_GIANT_LOGS).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy("has_advanced_saw", this._has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(wrapped, ResourceLocationHelper.loc((String)"twilightforest", (String)"giant_log_to_oak_planks").toString());
        wrapped = this.modLoaded(recipeOutput, "aquaculture");
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.OAK_PLANKS, (int)2).requires((ItemLike)SurvivalistEssentialsIntegration.AQUA_DRIFTWOOD).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy("has_driftwood", this._has(TagManager.Items.AQUA_DRIFTWOOD)).save(wrapped, ResourceLocationHelper.loc((String)"aquaculture", (String)"planks_from_driftwood").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.OAK_PLANKS, (int)4).requires((ItemLike)SurvivalistEssentialsIntegration.AQUA_DRIFTWOOD).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy("has_driftwood", this._has(TagManager.Items.AQUA_DRIFTWOOD)).save(wrapped, ResourceLocationHelper.prefix("planks_from_driftwood").toString());
        wrapped = this.modLoaded(recipeOutput, "immersiveengineering");
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsIntegration.IE_STICK_TREATED, (int)2).requires(TagManager.Items.IE_TREATED_WOOD).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("treated_sticks").unlockedBy("has_treated_planks", this._has(TagManager.Items.IE_TREATED_WOOD)).save(wrapped, ResourceLocationHelper.prefix("stick_treated").toString());
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsIntegration.IE_STICK_TREATED, (int)4).requires(TagManager.Items.IE_TREATED_WOOD).requires(TagManager.Items.IE_TREATED_WOOD).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("treated_sticks").unlockedBy("has_treated_planks", this._has(TagManager.Items.IE_TREATED_WOOD)).save(wrapped, ResourceLocationHelper.loc((String)"immersiveengineering", (String)"crafting/stick_treated").toString());
        wrapped = this.modLoaded(recipeOutput, "ecologics");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_COCONUT_PLANKS, TagManager.Items.ECO_COCONUT_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_WALNUT_PLANKS, TagManager.Items.ECO_WALNUT_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_AZALEA_PLANKS, TagManager.Items.ECO_AZALEA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_FLOWERING_AZALEA_PLANKS, TagManager.Items.ECO_FLOWERING_AZALEA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        ShapelessRecipeBuilder.shapeless((HolderGetter)itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)2).requires(ItemTags.PLANKS).requires(TagManager.Items.SAW_TOOLS).group("sticks").unlockedBy("has_planks", this._has((TagKey<Item>)ItemTags.PLANKS)).save(recipeOutput);
        wrapped = this.modLoaded(recipeOutput, "malum");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.MALUM_RUNEWOOD_PLANKS, TagManager.Items.MALUM_RUNEWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.MALUM_SOULWOOD_PLANKS, TagManager.Items.MALUM_SOULWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "iceandfire");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.IFD_DREADWOOD_PLANKS, TagManager.Items.IFD_DREADWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        wrapped = this.modLoaded(recipeOutput, "regions_unexplored");
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_ALPHA_PLANKS, TagManager.Items.RU_ALPHA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_ACACIA_BRANCH, "regions_unexplored", "", "stick_from_acacia_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BAOBAB_PLANKS, TagManager.Items.RU_BAOBAB_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BAOBAB_BRANCH, "regions_unexplored", "", "stick_from_baobab_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BIRCH_BRANCH, "regions_unexplored", "", "stick_from_birch_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BLACKWOOD_PLANKS, TagManager.Items.RU_BLACKWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BLACKWOOD_BRANCH, "regions_unexplored", "", "stick_from_blackwood_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BLUE_BIOSHROOM_PLANKS, TagManager.Items.RU_BLUE_BIOSHROOM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BIOSHROOM_PLANKS, TagManager.Items.RU_BIOSHROOM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BRIMWOOD_PLANKS, TagManager.Items.RU_BRIMWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BRIMWOOD_BRANCH, "regions_unexplored", "", "stick_from_brimwood_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_COBALT_PLANKS, TagManager.Items.RU_COBALT_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_COBALT_BRANCH, "regions_unexplored", "", "stick_from_cobalt_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_CYPRESS_PLANKS, TagManager.Items.RU_CYPRESS_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_CYPRESS_BRANCH, "regions_unexplored", "", "stick_from_cypress_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_DARK_OAK_BRANCH, "regions_unexplored", "", "stick_from_dark_oak_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_DEAD_PLANKS, TagManager.Items.RU_DEAD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_DEAD_BRANCH, "regions_unexplored", "", "stick_from_dead_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_EUCALYPTUS_PLANKS, TagManager.Items.RU_EUCALYPTUS_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_EUCALYPTUS_BRANCH, "regions_unexplored", "", "stick_from_eucalyptus_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_GREEN_BIOSHROOM_PLANKS, TagManager.Items.RU_GREEN_BIOSHROOM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_JOSHUA_PLANKS, TagManager.Items.RU_JOSHUA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_JOSHUA_BRANCH, "regions_unexplored", "", "stick_from_joshua_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_JUNGLE_BRANCH, "regions_unexplored", "", "stick_from_jungle_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_KAPOK_PLANKS, TagManager.Items.RU_KAPOK_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_KAPOK_BRANCH, "regions_unexplored", "", "stick_from_kapok_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_LARCH_PLANKS, TagManager.Items.RU_LARCH_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_LARCH_BRANCH, "regions_unexplored", "", "stick_from_larch_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MANGROVE_BRANCH, "regions_unexplored", "", "stick_from_mangrove_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAGNOLIA_PLANKS, TagManager.Items.RU_MAGNOLIA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAGNOLIA_BRANCH, "regions_unexplored", "", "stick_from_magnolia_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAPLE_PLANKS, TagManager.Items.RU_MAPLE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAPLE_BRANCH, "regions_unexplored", "", "stick_from_maple_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAUVE_PLANKS, TagManager.Items.RU_MAUVE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAUVE_BRANCH, "regions_unexplored", "", "stick_from_mauve_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_OAK_BRANCH, "regions_unexplored", "", "stick_from_oak_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PALM_PLANKS, TagManager.Items.RU_PALM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PALM_BRANCH, "regions_unexplored", "", "stick_from_palm_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PINE_PLANKS, TagManager.Items.RU_PINE_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PINE_BRANCH, "regions_unexplored", "", "stick_from_pine_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PINK_BIOSHROOM_PLANKS, TagManager.Items.RU_PINK_BIOSHROOM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_REDWOOD_PLANKS, TagManager.Items.RU_REDWOOD_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_REDWOOD_BRANCH, "regions_unexplored", "", "stick_from_redwood_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SILVER_BIRCH_BRANCH, "regions_unexplored", "", "stick_from_silver_birch_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SOCOTRA_PLANKS, TagManager.Items.RU_SOCOTRA_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SOCOTRA_BRANCH, "regions_unexplored", "", "stick_from_socotra_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SPRUCE_BRANCH, "regions_unexplored", "", "stick_from_spruce_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_WILLOW_PLANKS, TagManager.Items.RU_WILLOW_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_WILLOW_BRANCH, "regions_unexplored", "", "stick_from_willow_branch", (HolderLookup.RegistryLookup<Item>)itemRegistry);
        this.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_YELLOW_BIOSHROOM_PLANKS, TagManager.Items.RU_YELLOW_BIOSHROOM_LOGS, "has_logs", (HolderLookup.RegistryLookup<Item>)itemRegistry);
    }

    default public void sticksFromBranchRecipeBuilder(RecipeOutput recipeOutput, ItemLike item, String modid, String folder, String name, HolderLookup.RegistryLookup<Item> itemRegistry) {
        ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)2).requires(item).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("sticks").unlockedBy("has_branch", this._has(item)).save(recipeOutput, ResourceLocationHelper.loc((String)modid, (String)(folder + name)).toString());
        ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)4).requires(item).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("sticks").unlockedBy("has_branch", this._has(item)).save(recipeOutput, ResourceLocationHelper.prefix(modid + "_" + name).toString());
    }

    default public void plankRecipeBuilder(RecipeOutput recipeOutput, ItemLike item, TagKey<Item> itemTag, String label, HolderLookup.RegistryLookup<Item> itemRegistry) {
        ShapelessRecipeBuilder plankOverrideRecipe = ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)2).requires(itemTag).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy(label, this._has(itemTag));
        ResourceLocation itemLoc = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        String name = itemLoc.getPath();
        String modid = itemLoc.getNamespace();
        if (modid.contains("tconstruct")) {
            plankOverrideRecipe.save(recipeOutput, ResourceLocationHelper.loc((String)"tconstruct", (String)("world/wood/" + name.split("_")[0] + "/planks")).toString());
        } else if (modid.contains("quark")) {
            plankOverrideRecipe.save(recipeOutput, ResourceLocationHelper.loc((String)"quark", (String)("world/crafting/woodsets/" + name.split("_")[0] + "/planks")).toString());
        } else if (modid.contains("iceandfire")) {
            plankOverrideRecipe.save(recipeOutput, ResourceLocationHelper.loc((String)"iceandfire", (String)"dread_wood_planks").toString());
        } else if (itemTag.equals(TagManager.Items.BYG_PALO_VERDE_LOGS)) {
            plankOverrideRecipe.save(recipeOutput, ResourceLocationHelper.loc((String)"biomeswevegone", (String)"birch_planks_from_palo_verde_logs").toString());
            modid = "biomeswevegone";
        } else {
            plankOverrideRecipe.save(recipeOutput);
        }
        ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)4).requires(itemTag).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy(label, this._has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(recipeOutput, ResourceLocationHelper.prefix(modid + "_" + name).toString());
    }

    default public void itemPlankRecipeBuilder(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input, String label, String path, String name, String modid, HolderLookup.RegistryLookup<Item> itemRegistry) {
        ShapelessRecipeBuilder plankOverrideRecipe = ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)2).requires(input).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy(label, this._has(input));
        plankOverrideRecipe.save(recipeOutput, ResourceLocationHelper.loc((String)modid, (String)(path + name)).toString());
        ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).requires(input).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy(label, this._has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(recipeOutput, ResourceLocationHelper.prefix(modid + "_" + name).toString());
    }

    default public void bambooRecipeBuilder(RecipeOutput recipeOutput, ItemLike item, TagKey<Item> itemTag, String label, HolderLookup.RegistryLookup<Item> itemRegistry) {
        ShapelessRecipeBuilder plankOverrideRecipe = ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)1).requires(itemTag).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy(label, this._has(itemTag));
        ResourceLocation itemLoc = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        String name = itemLoc.getPath();
        String modid = itemLoc.getNamespace();
        plankOverrideRecipe.save(recipeOutput);
        ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)2).requires(itemTag).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy(label, this._has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(recipeOutput, ResourceLocationHelper.prefix(modid + "_" + name).toString());
    }

    default public void smokedLeatherRecipeBuilder(RecipeOutput recipeOutput, ItemLike item, String name) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)item), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.LEATHER, (float)0.35f, (int)100).unlockedBy("has_cooked_meat", this._has(TagManager.Items.COOKED_MEAT)).save(recipeOutput, ResourceLocationHelper.prefix("leather_from_" + name + "_smoking").toString());
    }
}

