/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.items;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import survivalistessentials.items.ToolMaterials;
import survivalistessentials.items.item.Bandage;
import survivalistessentials.items.item.CrudeBandage;
import survivalistessentials.items.item.Mortar;
import survivalistessentials.items.item.SurvivalistEssentialsBook;
import survivalistessentials.items.item.WoodenCup;
import survivalistessentials.items.tool.CrudeHatchet;
import survivalistessentials.items.tool.SurvivalKnife;
import survivalistessentials.items.tool.SurvivalSaw;
import survivalistessentials.util.ResourceLocationHelper;

public final class SurvivalistEssentialsItems {
    private static final Map<ResourceLocation, Item> MISC_ITEMS = new LinkedHashMap<ResourceLocation, Item>();
    private static final Map<ResourceLocation, Item> TOOLS_AND_UTILITIES = new LinkedHashMap<ResourceLocation, Item>();
    private static final Map<ResourceLocation, Item> ALL = new LinkedHashMap<ResourceLocation, Item>();
    public static Item FLINT_SHARD = SurvivalistEssentialsItems.make("flint_shard");
    public static Item PLANT_FIBER = SurvivalistEssentialsItems.make("plant_fiber");
    public static Item PLANT_STRING = SurvivalistEssentialsItems.make("plant_string");
    public static Item OINTMENT = SurvivalistEssentialsItems.make("ointment");
    public static Item PLANT_PASTE = SurvivalistEssentialsItems.make("plant_paste");
    public static Item CLOTH = SurvivalistEssentialsItems.make("cloth");
    public static Item BOOK = SurvivalistEssentialsItems.registerBook("book");
    public static Item MODPACK_BOOK = SurvivalistEssentialsItems.registerBook("modpack_book");
    public static Item CRUDE_KNIFE = SurvivalistEssentialsItems.registerKnifeTool("crude_knife", ToolMaterials.FLINT);
    public static Item BASIC_KNIFE = SurvivalistEssentialsItems.registerKnifeTool("basic_knife", ToolMaterials.IRON);
    public static Item SHARP_KNIFE = SurvivalistEssentialsItems.registerKnifeTool("sharp_knife", ToolMaterials.DIAMOND);
    public static Item CRUDE_HATCHET = SurvivalistEssentialsItems.registerHatchetTool("crude_hatchet", ToolMaterials.STONE);
    public static Item SAW_HANDLE = SurvivalistEssentialsItems.registerSawTool("saw_handle", ToolMaterials.NONE, -8.0f);
    public static Item CRUDE_SAW_BLADE = SurvivalistEssentialsItems.registerSawBlade("crude_saw_blade");
    public static Item BASIC_SAW_BLADE = SurvivalistEssentialsItems.registerSawBlade("basic_saw_blade");
    public static Item SHARP_SAW_BLADE = SurvivalistEssentialsItems.registerSawBlade("sharp_saw_blade");
    public static Item CRUDE_SAW = SurvivalistEssentialsItems.registerSawTool("crude_saw", ToolMaterials.FLINT, -4.0f);
    public static Item BASIC_SAW = SurvivalistEssentialsItems.registerSawTool("basic_saw", ToolMaterials.IRON, -4.0f);
    public static Item SHARP_SAW = SurvivalistEssentialsItems.registerSawTool("sharp_saw", ToolMaterials.DIAMOND, -4.0f);
    public static Item MORTAR_AND_PESTLE = SurvivalistEssentialsItems.registerMortar("mortar_and_pestle");
    public static Item CRUDE_BANDAGE = SurvivalistEssentialsItems.make("crude_bandage", new CrudeBandage(new Item.Properties().stacksTo(8).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix("crude_bandage")))), false, true);
    public static Item BANDAGE = SurvivalistEssentialsItems.make("bandage", new Bandage(new Item.Properties().stacksTo(16).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix("bandage")))), false, true);
    public static Item WOODEN_CUP = SurvivalistEssentialsItems.make("wooden_cup", new WoodenCup(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix("wooden_cup")))), false, false);

    public static void init(BiConsumer<Item, ResourceLocation> consumer) {
        for (Map.Entry<ResourceLocation, Item> entry : ALL.entrySet()) {
            consumer.accept(entry.getValue(), entry.getKey());
        }
    }

    public static Item registerSawBlade(String name) {
        return SurvivalistEssentialsItems.make(name, new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(name)))), true, false);
    }

    private static Item make(String name) {
        Item item = new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(name))));
        return SurvivalistEssentialsItems.make(name, item, false, false);
    }

    private static Item make(String name, Item item, boolean isTool, boolean noCategory) {
        ResourceLocation loc = ResourceLocationHelper.prefix(name);
        ALL.put(loc, item);
        if (isTool) {
            TOOLS_AND_UTILITIES.put(loc, item);
        }
        if (noCategory) {
            MISC_ITEMS.put(loc, item);
        }
        return item;
    }

    private static Item registerKnifeTool(String name, ToolMaterial toolMaterial) {
        SurvivalKnife knifeTool = new SurvivalKnife(new Item.Properties().sword(toolMaterial, 1.0f, -3.0f).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(name))));
        return SurvivalistEssentialsItems.make(name, knifeTool, true, false);
    }

    private static Item registerHatchetTool(String name, ToolMaterial toolMaterial) {
        CrudeHatchet hatchetTool = new CrudeHatchet(toolMaterial, 4.0f, -3.0f, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(name))));
        return SurvivalistEssentialsItems.make(name, (Item)hatchetTool, true, false);
    }

    private static Item registerSawTool(String name, ToolMaterial toolMaterial, float speed) {
        SurvivalSaw sawTool = new SurvivalSaw(name, toolMaterial, speed, 0.0f, new Item.Properties().attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(name))));
        return SurvivalistEssentialsItems.make(name, sawTool, true, false);
    }

    private static Item registerMortar(String name) {
        return SurvivalistEssentialsItems.make(name, new Mortar(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(name)))), false, false);
    }

    public static Item registerBook(String name) {
        return SurvivalistEssentialsItems.make(name, (Item)new SurvivalistEssentialsBook(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(name)))), false, true);
    }

    public static Map<ResourceLocation, Item> getAllIngredients() {
        return MISC_ITEMS;
    }

    public static Map<ResourceLocation, Item> getToolsAndUtilities() {
        return TOOLS_AND_UTILITIES;
    }

    public static Map<ResourceLocation, Item> getAll() {
        return ALL;
    }
}

