/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.util;

import java.util.List;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import survivalistessentials.common.TagManager;
import survivalistessentials.common.loot.LootItemBlockIsTagCondition;

public class LootConditionHelper {
    public static LootItemCondition[] createKnifeChanceCondition(float chance, TagKey<Block> tag, HolderLookup.RegistryLookup<Item> itemRegistryLookup) {
        return new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)chance).build(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(itemRegistryLookup, TagManager.Items.KNIFE_TOOLS)).build(), LootItemBlockIsTagCondition.isTag(tag)};
    }

    public static LootItemCondition[] createExtraStickDropConditions(float chance, TagKey<Block> tag, HolderLookup.RegistryLookup<Enchantment> enchantmentRegistryLookup, HolderLookup.RegistryLookup<Item> itemRegistryLookup, HolderLookup.RegistryLookup<EntityType<?>> entityRegistryLookup) {
        return new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)chance).build(), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityRegistryLookup, EntityType.PLAYER)).build(), LootItemBlockIsTagCondition.isTag(tag), LootConditionHelper.hasSilkTouch(enchantmentRegistryLookup).invert().build(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(itemRegistryLookup, TagManager.Items.SHEAR_TOOLS)).invert().build()};
    }

    private static LootItemCondition.Builder hasSilkTouch(HolderLookup.RegistryLookup<Enchantment> enchantmentRegistryLookup) {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantmentRegistryLookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))).build()));
    }
}

