/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.world.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LooseRockBlock
extends Block {
    public static final VoxelShape rockHitbox = LooseRockBlock.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)2.0, (double)11.0);

    public LooseRockBlock(ResourceKey<Block> resourceKey) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).sound(SoundType.STONE).strength(0.0f).noCollision().noOcclusion().setId(resourceKey));
    }

    protected void neighborChanged(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @Nullable Orientation orientation, boolean isMoving) {
        if (!state.canSurvive((LevelReader)level, pos) && !level.isClientSide()) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateUnder = level.getBlockState(pos.below());
        return stateUnder.isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return rockHitbox;
    }
}

