/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.client;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import survivalistessentials.world.SurvivalistEssentialsWorld;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "survivalistessentials", exFileHelper);
    }

    public String getName() {
        return "SurvivalistEssentials - Block State and Models";
    }

    protected void registerStatesAndModels() {
        this.generateLooseRockBaseModel();
        this.generateLooseRockVariants(SurvivalistEssentialsWorld.ANDESITE_LOOSE_ROCK);
        this.generateLooseRockVariants(SurvivalistEssentialsWorld.DIORITE_LOOSE_ROCK);
        this.generateLooseRockVariants(SurvivalistEssentialsWorld.GRANITE_LOOSE_ROCK);
        this.generateLooseRockVariants(SurvivalistEssentialsWorld.STONE_LOOSE_ROCK);
        this.generateLooseRockVariants(SurvivalistEssentialsWorld.SANDSTONE_LOOSE_ROCK);
        this.generateLooseRockVariants(SurvivalistEssentialsWorld.RED_SANDSTONE_LOOSE_ROCK);
        this.generateLooseRockVariants(SurvivalistEssentialsWorld.ROCK_STONE_BLOCK);
    }

    private void generateLooseRockBaseModel() {
        BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/loose_rock", this.mcLoc("block/block"))).texture("particle", "#all");
        this.addFaces(base.element().from(4.0f, 0.0f, 4.0f).to(5.0f, 1.0f, 5.0f));
        this.addFaces(base.element().from(7.0f, 0.0f, 3.0f).to(8.0f, 1.0f, 4.0f));
        this.addFaces(base.element().from(5.0f, 0.0f, 7.0f).to(6.0f, 1.0f, 8.0f));
        this.addFaces(base.element().from(5.0f, 0.0f, 10.0f).to(6.0f, 1.0f, 11.0f));
        this.addFaces(base.element().from(11.0f, 0.0f, 6.0f).to(12.0f, 1.0f, 7.0f));
        this.addFaces(base.element().from(10.0f, 0.0f, 10.0f).to(11.0f, 1.0f, 11.0f));
        this.addFaces(base.element().from(9.0f, 0.0f, 8.0f).to(10.0f, 1.0f, 9.0f));
        this.addFaces(base.element().from(7.0f, 0.0f, 9.0f).to(8.0f, 1.0f, 10.0f));
        this.addFaces(base.element().from(7.0f, 1.0f, 6.0f).to(8.0f, 2.0f, 7.0f));
        this.addFaces(base.element().from(6.0f, 1.0f, 7.0f).to(7.0f, 2.0f, 8.0f));
        this.addFaces(base.element().from(8.0f, 1.0f, 8.0f).to(9.0f, 2.0f, 9.0f));
        this.addFaces(base.element().from(6.0f, 0.0f, 6.0f).to(9.0f, 1.0f, 9.0f));
    }

    private void addFaces(ModelBuilder.ElementBuilder elementBuilder) {
        elementBuilder.allFaces((direction, faceBuilder) -> {
            ModelBuilder.ElementBuilder.FaceBuilder f = faceBuilder.uvs(0.0f, 0.0f, 12.0f, 12.0f).texture("#all");
        }).end();
    }

    private void generateLooseRockVariants(Block block) {
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)block);
        String type = Objects.requireNonNull(name).getPath().replace("_loose_rock", "");
        if (type.contains("rock_stone")) {
            type = "stone";
        }
        ModelBuilder modelFile = ((BlockModelBuilder)this.models().withExistingParent(name.toString(), this.modLoc("block/loose_rock"))).texture("all", this.modLoc("block/" + type + "_loose_rock"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$generateLooseRockVariants$1((ModelFile)modelFile, arg_0));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$generateLooseRockVariants$1(ModelFile modelFile, BlockState state) {
        return ConfiguredModel.builder().modelFile(modelFile).build();
    }
}

