/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.client;

import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.world.SurvivalistEssentialsWorld;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "survivalistessentials", existingFileHelper);
    }

    public String getName() {
        return "SurvivalistEssentials - Item Models";
    }

    protected void registerModels() {
        this.blockItem(SurvivalistEssentialsWorld.ANDESITE_LOOSE_ROCK);
        this.blockItem(SurvivalistEssentialsWorld.DIORITE_LOOSE_ROCK);
        this.blockItem(SurvivalistEssentialsWorld.GRANITE_LOOSE_ROCK);
        this.blockItem(SurvivalistEssentialsWorld.STONE_LOOSE_ROCK);
        this.blockItem(SurvivalistEssentialsWorld.SANDSTONE_LOOSE_ROCK);
        this.blockItem(SurvivalistEssentialsWorld.RED_SANDSTONE_LOOSE_ROCK);
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
        ModelFile.ExistingModelFile itemHandheld = this.getExistingFile(this.mcLoc("item/handheld"));
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsWorld.ROCK_STONE);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.FLINT_SHARD);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.PLANT_FIBER);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.PLANT_STRING);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.OINTMENT);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.PLANT_PASTE);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.CLOTH);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.CRUDE_SAW_BLADE);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.BASIC_SAW_BLADE);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.SHARP_SAW_BLADE);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.CRUDE_KNIFE);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.BASIC_KNIFE);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.SHARP_KNIFE);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.CRUDE_HATCHET);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.SAW_HANDLE);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.CRUDE_SAW);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.BASIC_SAW);
        this.build((ModelFile)itemHandheld, SurvivalistEssentialsItems.SHARP_SAW);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.MORTAR_AND_PESTLE);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.CRUDE_BANDAGE);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.BANDAGE);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.WOODEN_CUP);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.BOOK);
        this.build((ModelFile)itemGenerated, SurvivalistEssentialsItems.MODPACK_BOOK);
    }

    private void build(ModelFile itemGenerated, Item item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", "item/" + name);
    }

    protected void blockItem(Block block) {
        String type = BuiltInRegistries.BLOCK.getKey((Object)block).getPath().replace("_loose_rock", "");
        ItemModelBuilder builder = Optional.of(block).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).map(ResourceLocation::getPath).map(path -> (ItemModelBuilder)this.withExistingParent((String)path, this.modLoc("block/" + path))).orElseThrow(() -> new IllegalStateException("Failed to create model for Block Item"));
        builder.texture("all", this.modLoc("block/" + type + "_loose_rock"));
    }
}

