/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import survivalistessentials.sound.SurvivalistEssentialsSounds;
import survivalistessentials.util.ItemUse;

public class EquipmentChangeHandler {
    public static void handleChange(Player player, EquipmentSlot slot, ItemStack to) {
        if (slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && ItemUse.isArmor(to) && !ItemUse.isAllowedArmor(to)) {
            ItemStack itemstack = player.getItemBySlot(slot);
            Level level = player.level();
            level.playSound(null, player.getOnPos(), SurvivalistEssentialsSounds.ARMOR_FAIL, SoundSource.PLAYERS, 0.4f, 1.0f);
            if (!player.addItem(itemstack)) {
                NonNullList dropStack = NonNullList.withSize((int)1, (Object)itemstack);
                Vec3 pos = player.getEyePosition(1.0f);
                Containers.dropContents((Level)player.level(), (BlockPos)new BlockPos((int)pos.x(), (int)pos.y(), (int)pos.z()), (NonNullList)dropStack);
            }
            player.setItemSlot(slot, ItemStack.EMPTY);
        }
    }
}

