/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.items.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.world.effect.SurvivalistEssentialsEffects;

public class ItemBase
extends Item {
    private final UseAnim animation;

    public ItemBase(Item.Properties props, UseAnim animation) {
        super(props);
        this.animation = animation;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        if (!level.isClientSide) {
            String name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
            if (name.contains("bandage")) {
                int amplifier = 0;
                if (!name.contains("crude")) {
                    amplifier = 1;
                }
                Holder effect = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)SurvivalistEssentialsEffects.STOP_BLEEDING);
                entity.addEffect(new MobEffectInstance(effect, 600, amplifier));
            } else if (name.contains("cup")) {
                Holder effect = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)SurvivalistEssentialsEffects.ZOMBIE_ESSENCE);
                entity.addEffect(new MobEffectInstance(effect, 3600, 1));
            }
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        if (this.animation == UseAnim.DRINK) {
            level.gameEvent((Entity)entity, (Holder)GameEvent.DRINK, entity.getEyePosition());
        }
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        String name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        boolean stopBleeding = player.hasEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)SurvivalistEssentialsEffects.STOP_BLEEDING));
        boolean zombieEssence = player.hasEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)SurvivalistEssentialsEffects.ZOMBIE_ESSENCE));
        if (name.contains("bandage") ? stopBleeding || player.getHealth() >= player.getMaxHealth() : name.contains("cup") && zombieEssence) {
            return InteractionResultHolder.fail((Object)stack);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return this.animation;
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity pEntity) {
        return 1;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        return SoundEvents.PLAYER_ATTACK_WEAK;
    }
}

