/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.items.tool;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.common.TagManager;
import survivalistessentials.items.RecipeRemainderSwordItem;

public class SurvivalKnife
extends RecipeRemainderSwordItem {
    public SurvivalKnife(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    @NotNull
    public ItemStack getRemainingItem(@NotNull ItemStack stack) {
        ItemStack container = stack.copy();
        container.setDamageValue(container.getDamageValue() + 1);
        if (container.getDamageValue() < container.getMaxDamage()) {
            return container;
        }
        stack.shrink(1);
        return ItemStack.EMPTY;
    }

    public boolean mineBlock(@NotNull ItemStack knife, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity player) {
        float destroySpeed = state.getDestroySpeed((BlockGetter)level, pos);
        if (destroySpeed != 0.0f) {
            this.doDamage(knife, player);
        } else if (state.is(TagManager.Blocks.FIBER_PLANTS) && (double)level.random.nextFloat() < 0.2) {
            this.doDamage(knife, player);
        }
        return true;
    }

    private void doDamage(ItemStack knife, LivingEntity player) {
        knife.hurtAndBreak(1, player, EquipmentSlot.MAINHAND);
    }
}

