/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.mixin;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.sound.SurvivalistEssentialsSounds;
import survivalistessentials.util.ResourceLocationHelper;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Unique
    ResourceLocation flintLoc = ResourceLocationHelper.prefix("flint");

    @Shadow
    public abstract Item asItem();

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void survivalistessentials$onUse(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (BuiltInRegistries.ITEM.getKey((Object)this.asItem()).getPath().equals(this.flintLoc.getPath())) {
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            Level level = context.getLevel();
            Player player = context.getPlayer();
            InteractionHand hand = context.getHand();
            if (state.is(BlockTags.MINEABLE_WITH_PICKAXE) && Objects.requireNonNull(context.getPlayer()).getMainHandItem().getItem().equals(Items.FLINT)) {
                if (level.isClientSide()) {
                    Objects.requireNonNull(player).swing(hand);
                } else if (!level.isClientSide) {
                    if ((double)level.random.nextFloat() < 0.75) {
                        if ((double)level.random.nextFloat() < ConfigHandler.Common.flintChance()) {
                            NonNullList dropStack = NonNullList.withSize((int)1, (Object)new ItemStack((ItemLike)SurvivalistEssentialsItems.FLINT_SHARD, 4));
                            Containers.dropContents((Level)level, (BlockPos)Objects.requireNonNull(player).getOnPos(), (NonNullList)dropStack);
                        }
                        Objects.requireNonNull(player).getItemInHand(hand).shrink(1);
                    }
                    level.playSound(null, Objects.requireNonNull(player).getOnPos(), SurvivalistEssentialsSounds.FLINT_KNAPPING, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        }
    }
}

