/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.world;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.world.block.LooseRockBlock;
import survivalistessentials.world.item.RockStone;

public final class SurvivalistEssentialsWorld {
    private static final Map<ResourceLocation, Item> ALL = new LinkedHashMap<ResourceLocation, Item>();
    public static final Map<ResourceLocation, Block> ALL_BLOCKS = new LinkedHashMap<ResourceLocation, Block>();
    public static Block ANDESITE_LOOSE_ROCK;
    public static Block DIORITE_LOOSE_ROCK;
    public static Block GRANITE_LOOSE_ROCK;
    public static Block STONE_LOOSE_ROCK;
    public static Block SANDSTONE_LOOSE_ROCK;
    public static Block RED_SANDSTONE_LOOSE_ROCK;
    public static Block ROCK_STONE_BLOCK;
    public static Item ROCK_STONE;

    public static void initBlocks(BiConsumer<Block, ResourceLocation> consumer) {
        ANDESITE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("andesite_loose_rock");
        DIORITE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("diorite_loose_rock");
        GRANITE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("granite_loose_rock");
        STONE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("stone_loose_rock");
        SANDSTONE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("sandstone_loose_rock");
        RED_SANDSTONE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("red_sandstone_loose_rock");
        ROCK_STONE_BLOCK = SurvivalistEssentialsWorld.makeBlock("rock_stone_block");
        for (Map.Entry<ResourceLocation, Block> entry : ALL_BLOCKS.entrySet()) {
            consumer.accept(entry.getValue(), entry.getKey());
        }
    }

    public static void initItems(BiConsumer<Item, ResourceLocation> consumer) {
        SurvivalistEssentialsWorld.make("andesite_loose_rock", ANDESITE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("diorite_loose_rock", DIORITE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("granite_loose_rock", GRANITE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("stone_loose_rock", STONE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("sandstone_loose_rock", SANDSTONE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("red_sandstone_loose_rock", RED_SANDSTONE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("rock_stone_block", ROCK_STONE_BLOCK);
        for (Map.Entry<ResourceLocation, Item> entry : ALL.entrySet()) {
            consumer.accept(entry.getValue(), entry.getKey());
        }
    }

    private static Block makeBlock(String name) {
        LooseRockBlock block = new LooseRockBlock();
        ALL_BLOCKS.put(ResourceLocationHelper.prefix(name), block);
        return block;
    }

    private static void make(String name, Block block) {
        SurvivalistEssentialsWorld.make(name, (Item)new BlockItem(block, new Item.Properties()));
        if (name.contains("rock_stone_block")) {
            ROCK_STONE = SurvivalistEssentialsWorld.make("rock_stone", (Item)new RockStone(block, new Item.Properties()));
        }
    }

    private static Item make(String name, Item item) {
        ResourceLocation loc = ResourceLocationHelper.prefix(name);
        ALL.put(loc, item);
        return item;
    }

    public static Map<ResourceLocation, Item> getAll() {
        return ALL;
    }
}

