/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.recipe;

import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.data.recipe.ConfigResourceCondition;
import survivalistessentials.data.recipe.ISurvivalistEssentialsRecipeProvider;

public class NeoForgeRecipeProvider
extends RecipeProvider.Runner
implements ISurvivalistEssentialsRecipeProvider {
    private InternalRecipeProvider internalRecipeProvider;

    public NeoForgeRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    @NotNull
    protected RecipeProvider createRecipeProvider(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull RecipeOutput recipeOutput) {
        this.internalRecipeProvider = new InternalRecipeProvider(provider, recipeOutput);
        return this.internalRecipeProvider;
    }

    @NotNull
    public String getName() {
        return "SurvivalistEssentials - NeoForge Recipes";
    }

    @Override
    public RecipeOutput modLoaded(RecipeOutput recipeOutput, String modid) {
        return recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition(modid)});
    }

    @Override
    public RecipeOutput modNotLoaded(RecipeOutput recipeOutput, String modid) {
        return recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition(modid))});
    }

    @Override
    public RecipeOutput configResourceCondition(RecipeOutput recipeOutput, String configOption) {
        return recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition(configOption)});
    }

    @Override
    public Criterion<InventoryChangeTrigger.TriggerInstance> _has(ItemLike itemLike) {
        return this.internalRecipeProvider._has(itemLike);
    }

    @Override
    public Criterion<InventoryChangeTrigger.TriggerInstance> _has(TagKey<Item> tag) {
        return this.internalRecipeProvider._has(tag);
    }

    private class InternalRecipeProvider
    extends RecipeProvider {
        RecipeOutput recipeOutput;
        HolderLookup.Provider registries;

        protected InternalRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            super(registries, output);
            this.recipeOutput = output;
            this.registries = registries;
        }

        public void buildRecipes() {
            NeoForgeRecipeProvider.this.buildModRecipes(this.registries, this.recipeOutput);
        }

        public Criterion<InventoryChangeTrigger.TriggerInstance> _has(ItemLike itemLike) {
            return this.has(itemLike);
        }

        public Criterion<InventoryChangeTrigger.TriggerInstance> _has(TagKey<Item> tag) {
            return this.has(tag);
        }
    }
}

