/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.common.TagManager;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.mixin.AbstractBlockStateAccessor;
import survivalistessentials.sound.SurvivalistEssentialsSounds;
import survivalistessentials.util.Chat;
import survivalistessentials.util.ItemUse;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.util.ToolType;
import technology.roughness.whitenoise.platform.Services;

public class HarvestEventHandler {
    private static final Map<Player, BlockPos> harvestAttempts = new HashMap<Player, BlockPos>();
    private static Block spellHitBlock = null;
    private static int breakBlockStep = 0;

    public static boolean shouldCancelBreakBlock(LevelAccessor level, BlockPos pos, Player player) {
        ItemStack handStack;
        boolean alwaysBreakable;
        BlockState state = level.getBlockState(pos);
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.getBlock(), ToolType.NONE);
        boolean cancel = false;
        boolean bl = alwaysBreakable = state.is(TagManager.Blocks.ALWAYS_BREAKABLE) || ItemUse.isAlwaysBreakable(state);
        if (Services.PLATFORM.isModLoaded("carryon")) {
            handStack = player.getMainHandItem();
            ItemStack offhandStack = player.getOffhandItem();
            if (handStack.isEmpty() && offhandStack.isEmpty() && survivalistessentials.platform.Services.PLATFORM_HELPER.isCarryonKeyPressed(player)) {
                alwaysBreakable = true;
            }
        }
        if (Services.PLATFORM.isModLoaded("create")) {
            handStack = player.getMainHandItem();
            boolean bl2 = alwaysBreakable = ResourceLocationHelper.getModId((ItemStack)handStack).equals("create") && ResourceLocationHelper.getModId((Block)state.getBlock()).equals("create");
        }
        if (!alwaysBreakable && !player.isCreative() && expectedToolType != ToolType.NONE) {
            handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            boolean isAllowedTool = ItemUse.isAllowedTool(handStack);
            String toolClass = ItemUse.getToolClass(handStack);
            if (toolClass.equals("unknown") || isAllowedTool && !correctTool) {
                cancel = true;
                if (harvestAttempts.containsKey(player) || harvestAttempts.get(player) == null || !harvestAttempts.get(player).equals((Object)pos)) {
                    harvestAttempts.put(player, pos);
                    Chat.sendMessage(player, "message.survivalistessentials.wrong_tool", expectedToolType.toString().toLowerCase(), false);
                } else {
                    Chat.sendMessage(player, "message.survivalistessentials.warning");
                    Chat.sendMessage(player, "message.survivalistessentials.wrong_tool2", expectedToolType.toString().toLowerCase(), true);
                    player.hurt(player.damageSources().generic(), 0.1f);
                }
                if (!toolClass.equals("unknown") && !player.level().isClientSide() && ConfigHandler.Client.enableFailSound()) {
                    level.playSound(null, player.getOnPos(), SurvivalistEssentialsSounds.TOOL_FAIL, SoundSource.PLAYERS, 0.6f, 1.0f);
                }
            } else if (spellHitBlock != null) {
                if (breakBlockStep == 1) {
                    breakBlockStep = -1;
                    spellHitBlock = null;
                }
                ++breakBlockStep;
            }
        }
        return cancel;
    }

    public static void setSpellHitBlock(Block block) {
        spellHitBlock = block;
    }

    public static boolean canHarvest(Player player, BlockState state, boolean originalCanHarvest) {
        if (!player.isCreative()) {
            boolean canHarvest;
            ItemStack handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.getBlock(), ToolType.NONE);
            boolean bl = canHarvest = originalCanHarvest || ItemUse.alwaysDrops(state) || expectedToolType == ToolType.NONE;
            if (!canHarvest) {
                boolean isOre;
                boolean bl2 = isOre = state.is(TagManager.Blocks.ORES) || state.is(TagManager.Blocks.OBSIDIANS);
                canHarvest = isOre && expectedToolType == ToolType.PICKAXE ? correctTool && handStack.isCorrectToolForDrops(state) : correctTool || handStack.isCorrectToolForDrops(state);
            }
            return canHarvest;
        }
        return true;
    }

    public static Pair<Boolean, Float> getMiningSlowdown(Player player, BlockState state) {
        float destroySpeed;
        float slowdown = destroySpeed = ((AbstractBlockStateAccessor)state).getDestroySpeed();
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.getBlock(), ToolType.NONE);
        if (!player.isCreative() && expectedToolType != ToolType.NONE) {
            ItemStack handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            boolean alwaysBreakable = state.is(TagManager.Blocks.ALWAYS_BREAKABLE);
            boolean isAllowedTool = ItemUse.isAllowedTool(handStack);
            if (!alwaysBreakable) {
                if (!isAllowedTool) {
                    slowdown = ConfigHandler.Common.slowDownSpeed() / 2.0f;
                } else if (!correctTool) {
                    slowdown = ConfigHandler.Common.slowDownSpeed();
                }
            } else if (!correctTool) {
                slowdown = ConfigHandler.Common.slowDownSpeed();
            } else if (!isAllowedTool) {
                slowdown = ConfigHandler.Common.slowDownSpeed() / 2.0f;
            }
        }
        if (slowdown != destroySpeed) {
            return Pair.of((Object)true, (Object)Float.valueOf(slowdown));
        }
        return Pair.of((Object)false, (Object)Float.valueOf(destroySpeed));
    }

    private static ItemStack getHandStack(Player player, BlockState blockState) {
        String toolClass;
        ItemStack stack = player.getMainHandItem();
        if (spellHitBlock != null && spellHitBlock.equals(blockState.getBlock()) && !Objects.equals(toolClass = ItemUse.getToolClass(stack), "spell") && !Objects.equals(toolClass, "cad")) {
            stack = player.getOffhandItem();
        }
        return stack;
    }
}

