/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.world;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.world.block.LooseRockBlock;
import survivalistessentials.world.item.RockStone;

public final class SurvivalistEssentialsWorld {
    private static final Map<ResourceLocation, Item> ALL = new LinkedHashMap<ResourceLocation, Item>();
    public static final Map<ResourceLocation, Block> ALL_BLOCKS = new LinkedHashMap<ResourceLocation, Block>();
    public static Block ANDESITE_LOOSE_ROCK;
    public static Block DIORITE_LOOSE_ROCK;
    public static Block GRANITE_LOOSE_ROCK;
    public static Block STONE_LOOSE_ROCK;
    public static Block SANDSTONE_LOOSE_ROCK;
    public static Block RED_SANDSTONE_LOOSE_ROCK;
    public static Item ROCK_STONE;

    public static void initBlocks(BiConsumer<Block, ResourceLocation> consumer) {
        ANDESITE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("andesite_loose_rock");
        DIORITE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("diorite_loose_rock");
        GRANITE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("granite_loose_rock");
        STONE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("stone_loose_rock");
        SANDSTONE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("sandstone_loose_rock");
        RED_SANDSTONE_LOOSE_ROCK = SurvivalistEssentialsWorld.makeBlock("red_sandstone_loose_rock");
        for (Map.Entry<ResourceLocation, Block> entry : ALL_BLOCKS.entrySet()) {
            consumer.accept(entry.getValue(), entry.getKey());
        }
    }

    public static void initItems(BiConsumer<Item, ResourceLocation> consumer) {
        SurvivalistEssentialsWorld.make("andesite_loose_rock", ANDESITE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("diorite_loose_rock", DIORITE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("granite_loose_rock", GRANITE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("stone_loose_rock", STONE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("sandstone_loose_rock", SANDSTONE_LOOSE_ROCK);
        SurvivalistEssentialsWorld.make("red_sandstone_loose_rock", RED_SANDSTONE_LOOSE_ROCK);
        for (Map.Entry<ResourceLocation, Item> entry : ALL.entrySet()) {
            consumer.accept(entry.getValue(), entry.getKey());
        }
    }

    private static Block makeBlock(String name) {
        ResourceLocation loc = ResourceLocationHelper.prefix(name);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)loc);
        LooseRockBlock block = new LooseRockBlock((ResourceKey<Block>)resourceKey);
        ALL_BLOCKS.put(loc, block);
        return block;
    }

    private static void make(String name, Block block) {
        ResourceLocation loc = ResourceLocationHelper.prefix(name);
        SurvivalistEssentialsWorld.make(loc, (Item)new BlockItem(block, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)loc))));
    }

    private static Item make(ResourceLocation loc, Item item) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockItem.registerBlocks(Item.BY_BLOCK, item);
        }
        ALL.put(loc, item);
        return item;
    }

    public static Map<ResourceLocation, Item> getAll() {
        return ALL;
    }

    static {
        ROCK_STONE = SurvivalistEssentialsWorld.make(ResourceLocationHelper.prefix("rock_stone"), new RockStone(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix("rock_stone")))));
    }
}

