/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.world.effect;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.world.effect.SurvivalistEssentialsEffects;

public class StopBleeding
extends MobEffect {
    public StopBleeding() {
        super(MobEffectCategory.BENEFICIAL, 16234413);
    }

    public boolean applyEffectTick(@NotNull ServerLevel level, LivingEntity entity, int amplifier) {
        float healRate = (float)ConfigHandler.Common.healRate();
        if (entity.getHealth() >= entity.getMaxHealth()) {
            entity.removeEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)SurvivalistEssentialsEffects.STOP_BLEEDING));
        }
        entity.heal(healRate * (float)(amplifier + 1));
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int j = 50 >> amplifier;
        if (j > 0) {
            return duration % j == 0;
        }
        return true;
    }
}

