/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.recipe;

import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.data.recipe.ConfigResourceCondition;
import survivalistessentials.data.recipe.ISurvivalistEssentialsRecipeProvider;

public class NeoForgeRecipeProvider
extends RecipeProvider
implements ISurvivalistEssentialsRecipeProvider {
    public NeoForgeRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.buildModRecipes(recipeOutput);
    }

    @Override
    public RecipeOutput modLoaded(RecipeOutput recipeOutput, String modid) {
        return recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition(modid)});
    }

    @Override
    public RecipeOutput modNotLoaded(RecipeOutput recipeOutput, String modid) {
        return recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition(modid))});
    }

    @Override
    public RecipeOutput configResourceCondition(RecipeOutput recipeOutput, String configOption) {
        return recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition(configOption)});
    }

    @Override
    public Criterion<InventoryChangeTrigger.TriggerInstance> _has(ItemLike itemLike) {
        return NeoForgeRecipeProvider.has((ItemLike)itemLike);
    }

    @Override
    public Criterion<InventoryChangeTrigger.TriggerInstance> _has(TagKey<Item> tag) {
        return NeoForgeRecipeProvider.has(tag);
    }
}

