/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.apache.commons.lang3.tuple.Pair;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.event.HarvestEventHandler;

public class HarvestEvents {
    @SubscribeEvent
    public static void tagUpdate(TagsUpdatedEvent event) {
        HarvestBlock.setup();
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        if (HarvestEventHandler.shouldCancelBreakBlock(event.getLevel(), event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void harvestCheckEvent(PlayerEvent.HarvestCheck event) {
        Player player = event.getEntity();
        BlockState state = event.getTargetBlock();
        if (!(player instanceof FakePlayer)) {
            event.setCanHarvest(HarvestEventHandler.canHarvest(player, state, event.canHarvest()));
        }
    }

    @SubscribeEvent
    public static void slowMining(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player instanceof FakePlayer) {
            return;
        }
        Pair<Boolean, Float> slowdown = HarvestEventHandler.getMiningSlowdown(player, event.getState());
        if (((Boolean)slowdown.getLeft()).booleanValue()) {
            event.setNewSpeed(((Float)slowdown.getRight()).floatValue());
        }
    }
}

