/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Chat {
    public static final String NOTICE = "message.survivalistessentials.notice";
    public static final String WARNING = "message.survivalistessentials.warning";
    public static final String TOOL_BROKE = "message.survivalistessentials.tool_broke";
    public static final String WRONG_TOOL = "message.survivalistessentials.wrong_tool";
    public static final String SARCASTIC_WRONG_TOOL = "message.survivalistessentials.wrong_tool2";

    public static void sendMessage(Player player, String title) {
        MutableComponent message = Component.translatable((String)title).withStyle(ChatFormatting.RED);
        if (title.contains(NOTICE)) {
            message = Component.translatable((String)title).withStyle(ChatFormatting.YELLOW);
        }
        Chat.sendMessage(player, (Component)message, false);
    }

    public static void sendMessage(Player player, String title, String replace, boolean delayed) {
        Chat.sendMessage(player, title, (Component)Component.translatable((String)replace), delayed);
    }

    public static void sendMessage(Player player, String title, ItemStack stack, boolean delayed) {
        Chat.sendMessage(player, title, stack.getItem(), delayed);
    }

    public static void sendMessage(Player player, String title, Item item, boolean delayed) {
        Component name = item.getDescription();
        Chat.sendMessage(player, title, name, delayed);
    }

    public static void sendMessage(Player player, String title, Component replace, boolean delayed) {
        MutableComponent message = Component.translatable((String)title, (Object[])new Object[]{replace, delayed});
        Chat.sendMessage(player, (Component)message, delayed);
    }

    private static void sendMessage(Player player, Component message, boolean delayed) {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        int delay = 0;
        if (delayed) {
            delay = 700;
        }
        executor.schedule(() -> player.displayClientMessage(message, true), (long)delay, TimeUnit.MILLISECONDS);
    }
}

