/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.client.handbook;

import handbook.api.data.BookBuilder;
import handbook.api.data.HandbookBookProvider;
import handbook.api.data.page.CraftingPageBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.world.SurvivalistEssentialsWorld;

public class SurvivalistEssentialsBookProvider
extends HandbookBookProvider {
    public SurvivalistEssentialsBookProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, "survivalistessentials", "en_us", lookupProvider);
    }

    protected void addBooks(Consumer<BookBuilder> consumer, HolderLookup.Provider provider) {
        String bookName = "item.survivalistessentials.book";
        String landingText = "info.survivalistessentials.book.intro";
        String subTitle = "info.survivalistessentials.book.subtitle";
        BookBuilder bookBuilder = this.createBookBuilder("book", bookName, landingText, provider).setSubtitle(subTitle).setCustomBookItem(new ItemStack((ItemLike)SurvivalistEssentialsItems.BOOK)).setCreativeTab("survivalistessentials.items").setModel("survivalistessentials:book").setDontGenerateBook(true).setShowProgress(false).setUseBlockyFont(true).setI18n(true);
        bookBuilder = this.addGettingStarted(bookBuilder);
        bookBuilder = this.addTools(bookBuilder);
        bookBuilder = this.addHealth(bookBuilder);
        bookBuilder.build(consumer);
    }

    private BookBuilder addGettingStarted(BookBuilder bookBuilder) {
        return ((CraftingPageBuilder)((CraftingPageBuilder)bookBuilder.addCategory("getting_started", "info.survivalistessentials.book.getting_started.name", "info.survivalistessentials.book.getting_started.desc", new ItemStack((ItemLike)SurvivalistEssentialsWorld.ROCK_STONE)).setSortnum(Integer.valueOf(0)).addEntry("getting_started/materials", "info.survivalistessentials.book.getting_started.materials.name", new ItemStack((ItemLike)SurvivalistEssentialsWorld.ROCK_STONE)).addSpotlightPage(new ItemStack[]{new ItemStack((ItemLike)SurvivalistEssentialsWorld.STONE_LOOSE_ROCK)}).setTitle("info.survivalistessentials.book.getting_started.materials.gather_stones.title").setText("info.survivalistessentials.book.getting_started.materials.gather_stones.desc").build().addSpotlightPage(new ItemStack[]{new ItemStack((ItemLike)Items.OAK_LEAVES)}).setTitle("info.survivalistessentials.book.getting_started.materials.gather_sticks.title").setText("info.survivalistessentials.book.getting_started.materials.gather_sticks.desc").build().addSpotlightPage(new ItemStack[]{new ItemStack((ItemLike)SurvivalistEssentialsItems.FLINT_SHARD)}).setTitle("info.survivalistessentials.book.getting_started.materials.flint_shards.title").setText("info.survivalistessentials.book.getting_started.materials.flint_shards.desc").build().addSpotlightPage(new ItemStack[]{new ItemStack((ItemLike)SurvivalistEssentialsItems.PLANT_FIBER)}).setTitle("info.survivalistessentials.book.getting_started.materials.plant_fiber.title").setText("info.survivalistessentials.book.getting_started.materials.plant_fiber.desc").build().addCraftingPage(ResourceLocationHelper.prefix("plant_string")).setTitle("info.survivalistessentials.book.getting_started.materials.plant_string.title")).setText("info.survivalistessentials.book.getting_started.materials.plant_string.desc")).build().build().build();
    }

    private BookBuilder addTools(BookBuilder bookBuilder) {
        return ((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)bookBuilder.addCategory("tools", "info.survivalistessentials.book.tools.name", "info.survivalistessentials.book.tools.desc", new ItemStack((ItemLike)SurvivalistEssentialsItems.SHARP_SAW)).setSortnum(Integer.valueOf(1)).addEntry("tools/crude_tools", "info.survivalistessentials.book.tools.crude_tools.name", new ItemStack((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW)).addCraftingPage(ResourceLocationHelper.prefix("crude_knife")).setTitle("item.survivalistessentials.crude_knife")).setText("info.survivalistessentials.book.tools.crude_tools.knife.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("flint_shard")).setTitle("info.survivalistessentials.book.tools.crude_tools.knife_recipes.name")).setText("info.survivalistessentials.book.tools.crude_tools.knife_recipes.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("crude_hatchet")).setTitle("item.survivalistessentials.crude_hatchet")).setText("info.survivalistessentials.book.tools.crude_tools.hatchet.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("crude_saw_blade")).setTitle("item.survivalistessentials.crude_saw_blade")).setText("info.survivalistessentials.book.tools.crude_tools.crude_saw_blade.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("saw_handle")).setTitle("item.survivalistessentials.saw_handle")).setText("info.survivalistessentials.book.tools.crude_tools.saw_handle.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("crude_saw")).setTitle("item.survivalistessentials.crude_saw")).setText("info.survivalistessentials.book.tools.crude_tools.crude_saw.desc")).build().addCraftingPage(ResourceLocationHelper.loc((String)"minecraft", (String)"oak_planks")).setTitle("info.survivalistessentials.book.tools.crude_tools.planks.name")).setText("info.survivalistessentials.book.tools.crude_tools.planks.desc")).build().addCraftingPage(ResourceLocationHelper.loc((String)"minecraft", (String)"stick")).setTitle("info.survivalistessentials.book.tools.crude_tools.sticks.name")).setText("info.survivalistessentials.book.tools.crude_tools.sticks.desc")).build().build().addEntry("tools/improved_tools", "info.survivalistessentials.book.tools.improved_tools.name", new ItemStack((ItemLike)SurvivalistEssentialsItems.SHARP_SAW_BLADE)).setSortnum(1).addSpotlightPage(new ItemStack[]{new ItemStack((ItemLike)SurvivalistEssentialsItems.SHARP_SAW)}).setText("info.survivalistessentials.book.tools.improved_tools.intro").setTitle("info.survivalistessentials.book.tools.improved_tools.subtitle").build().addCraftingPage(ResourceLocationHelper.prefix("basic_saw")).setRecipe2(ResourceLocationHelper.prefix("basic_saw_blade"))).build().addCraftingPage(ResourceLocationHelper.prefix("sharp_saw")).setRecipe2(ResourceLocationHelper.prefix("sharp_saw_blade"))).build().addCraftingPage(ResourceLocationHelper.prefix("basic_knife")).setRecipe2(ResourceLocationHelper.prefix("sharp_knife"))).build().build().build();
    }

    private BookBuilder addHealth(BookBuilder bookBuilder) {
        return ((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)bookBuilder.addCategory("health", "info.survivalistessentials.book.health.name", "info.survivalistessentials.book.health.desc", new ItemStack((ItemLike)SurvivalistEssentialsItems.BANDAGE)).setSortnum(Integer.valueOf(2)).addEntry("health/ingredients", "info.survivalistessentials.book.health.ingredients.name", new ItemStack((ItemLike)SurvivalistEssentialsItems.CLOTH)).addSpotlightPage(new ItemStack[]{new ItemStack((ItemLike)SurvivalistEssentialsItems.CLOTH)}).setText("info.survivalistessentials.book.health.ingredients.desc").setTitle("info.survivalistessentials.book.health.ingredients.subtitle").build().addCraftingPage(ResourceLocationHelper.prefix("cloth")).setTitle("item.survivalistessentials.cloth")).setText("info.survivalistessentials.book.health.ingredients.cloth.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("mortar_and_pestle")).setTitle("item.survivalistessentials.mortar_and_pestle")).setText("info.survivalistessentials.book.health.ingredients.mortar_and_pestle.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("plant_paste")).setTitle("item.survivalistessentials.plant_paste")).setText("info.survivalistessentials.book.health.ingredients.plant_paste.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("ointment")).setTitle("item.survivalistessentials.ointment")).setText("info.survivalistessentials.book.health.ingredients.ointment.desc")).build().build().addEntry("health/bandages", "info.survivalistessentials.book.health.bandages.name", new ItemStack((ItemLike)SurvivalistEssentialsItems.BANDAGE)).setSortnum(1).addSpotlightPage(new ItemStack[]{new ItemStack((ItemLike)SurvivalistEssentialsItems.BANDAGE)}).setText("info.survivalistessentials.book.health.bandages.desc").setTitle("info.survivalistessentials.book.health.bandages.subtitle").build().addCraftingPage(ResourceLocationHelper.prefix("crude_bandage")).setTitle("item.survivalistessentials.crude_bandage")).setText("info.survivalistessentials.book.health.bandages.crude_bandage.desc")).build().addCraftingPage(ResourceLocationHelper.prefix("bandage")).setTitle("item.survivalistessentials.bandage")).setText("info.survivalistessentials.book.health.bandages.bandage.desc")).build().build().build();
    }
}

